# Test Coverage

In software testing, we use test coverage to define the percent of executed tests.
Test coverage is a measurement in Software Testing that shows the percentage of product functionality which is tested and defines the amount of the entire testing circle.
It determines which branches of the program were examined and which conditions and setting were considered.

Software testing is an essential activity in the software development and maintenance life cycles.
It is a practice often used to decide and improve software quality.

Development is more systematic nowadays and organizations seek measures of testing completeness and effectiveness to show test completion criteria.
Of them all, coverage is considered especially valuable.

> Simply put, coverage is “What are we testing and How much are we testing?”

## Related Links and Tutorials

- [.NET Core Tools](https://docs.microsoft.com/en-us/dotnet/core/tools/global-tools#what-could-go-wrong)
- [Coverlet](https://github.com/tonerdo/coverlet)
- [ReportGenerator](https://danielpalme.github.io/ReportGenerator/)
- [DZone](https://dzone.com/articles/code-coverage-reports-for-aspnet-core)

## Generating Coverage Files

---

The first step required is to generate coverage files during the execution of tests.

### Coverlet

Coverlet is a cross platform code coverage framework for .NET, with support for line, branch and method coverage. It works with .NET Framework on Windows and .NET Core on all supported platforms.

- [Documentation](https://github.com/tonerdo/coverlet/blob/master/Documentation/GlobalTool.md)

Install the Coverlet globally.

```bash
dotnet tool install -g coverlet.console
```

Create a coverage file requires generating a file for each test project and merging them together.

```bash
coverlet ./tests/unit/api/bin/Debug/netcoreapp3.1/Pims.Api.Test.dll --target "dotnet" --targetargs "test ./ --no-build" -o "./tests/TestResults/coverage.json" --exclude "[*.Test]*" --exclude "[*]*Model" --exclude-by-attribute "CompilerGenerated" -f json

coverlet ./tests/unit/dal/bin/Debug/netcoreapp3.1/Pims.Dal.Test.dll --target "dotnet" --targetargs "test ./ --no-build" -o "./tests/TestResults/coverage.xml" --exclude "[*.Test]*" --exclude "[*]*Model" --exclude-by-attribute "CompilerGenerated" --merge-with "tests/TestResults/coverage.json" -f cobertura
```

### DotNet

You can also generate coverage files with dotnet, however you have less control with the output.
The problem with this is that it will create separate folders with GUID names for each test project.

Create a coverage file, based on the type.

```bash
dotnet test --collect:"Code Coverage" --results-directory:./tests/TestResults

dotnet test --collect:"XPlat Code Coverage" --results-directory:./tests/TestResults
```

## Generating Reports

---

ReportGenerator converts coverage reports generated by
OpenCover, dotCover, Visual Studio, NCover, Cobertura, JaCoCo, Clover, gcov or lcov
into human readable reports in various formats

[Documentation](https://danielpalme.github.io/ReportGenerator/usage.html)

Install ReportGenerator globally.

```bash
dotnet tool install -g dotnet-reportgenerator-globaltool
```

To generate the report files.

```bash
reportgenerator "-reports:./tests/TestResults/coverage.xml" "-targetdir:./tests/TestResults/Coverage" -reporttypes:Html

start ./tests/TestResults/Coverage/index.htm
```

Or if you want to only generate a summary report.

```bash
reportgenerator "-reports:./tests/TestResults/coverage.xml" "-targetdir:./tests/TestResults/Coverage" -reporttypes:HtmlSummary

start ./tests/TestResults/Coverage/summary.htm
```
