import { z } from 'zod';

const NoteSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  projectId: z.number(),
  noteType: z.number(),
  note: z.string(),
});

const EvaluationSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  parcelId: z.number(),
  date: z.string(),
  key: z.string(),
  value: z.number(),
  note: z.string(),
  firm: z.string(),
});

const FiscalSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  parcelId: z.number(),
  fiscalYear: z.number(),
  key: z.string(),
  value: z.number(),
  note: z.string(),
});

const BuildingSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  projectNumbers: z.array(z.string()),
  name: z.string(),
  description: z.string(),
  classificationId: z.number(),
  classification: z.string(),
  encumbranceReason: z.string(),
  agencyId: z.number(),
  subAgency: z.string(),
  agency: z.string(),
  address: z.object({
    createdOn: z.string(),
    updatedOn: z.string(),
    updatedByName: z.string(),
    updatedByEmail: z.string(),
    rowVersion: z.string(),
    id: z.number(),
    line1: z.string(),
    line2: z.string(),
    administrativeArea: z.string(),
    provinceId: z.string(),
    province: z.string(),
    postal: z.string(),
  }),
  latitude: z.number(),
  longitude: z.number(),
  isSensitive: z.boolean(),
  isVisibleToOtherAgencies: z.boolean(),
  parcelId: z.number(),
  buildingConstructionTypeId: z.number(),
  buildingConstructionType: z.string(),
  buildingFloorCount: z.number(),
  buildingPredominateUseId: z.number(),
  buildingPredominateUse: z.string(),
  buildingOccupantTypeId: z.number(),
  buildingOccupantType: z.string(),
  leaseExpiry: z.string(),
  occupantName: z.string(),
  transferLeaseOnSale: z.boolean(),
  buildingTenancy: z.string(),
  rentableArea: z.number(),
  landArea: z.number(),
  zoning: z.string(),
  zoningPotential: z.string(),
  evaluations: z.array(EvaluationSchema),
  fiscals: z.array(FiscalSchema),
});

const ParcelSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  pid: z.string(),
  pin: z.number(),
});

const PropertySchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  projectId: z.string(),
  propertyType: z.string(),
  parcelId: z.number(),
  parcel: ParcelSchema,
  buildingId: z.number(),
  building: BuildingSchema,
});

const TaskSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  projectId: z.string(),
  taskId: z.number(),
  isCompleted: z.boolean(),
  completedOn: z.string(),
  name: z.string(),
  description: z.string(),
  isOptional: z.boolean(),
  isDisabled: z.boolean(),
  sortOrder: z.number(),
  statusId: z.number(),
  statusCode: z.string(),
});

export type Task = z.infer<typeof TaskSchema>;

const ProjectAgencyResponseSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  projectId: z.number(),
  agencyId: z.number(),
  agencyCode: z.string(),
  notificationId: z.number(),
  response: z.string(),
  receivedOn: z.string(),
  note: z.string(),
  offerAmount: z.number(),
});

const StatusHistorySchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  workflowId: z.number(),
  workflow: z.string(),
  statusId: z.number(),
  status: z.string(),
});

const StatusSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  name: z.string(),
  isDisabled: z.boolean(),
  isVisible: z.boolean(),
  sortOrder: z.number(),
  type: z.string(),
  code: z.string(),
  parentId: z.number(),
  description: z.string(),
  route: z.string(),
  isTerminal: z.boolean(),
  tasks: z.array(TaskSchema),
});

export type Status = z.infer<typeof StatusSchema>;

export const ProjectSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  projectNumber: z.string(),
  name: z.string(),
  reportedFiscalYear: z.number(),
  actualFiscalYear: z.number(),
  manager: z.string(),
  sendNotifications: z.boolean(),
  workflowId: z.number(),
  workflowCode: z.string(),
  statusId: z.number(),
  statusCode: z.string(),
  status: StatusSchema,
  riskId: z.number(),
  risk: z.string(),
  tierLevelId: z.number(),
  tierLevel: z.string(),
  description: z.string(),
  note: z.string(),
  publicNote: z.string(),
  privateNote: z.string(),
  appraisedNote: z.string(),
  offersNote: z.string(),
  reportingNote: z.string(),
  purchaser: z.string(),
  isContractConditional: z.boolean(),
  agencyId: z.number(),
  agency: z.string(),
  agencyCode: z.string(),
  subAgency: z.string(),
  subAgencyCode: z.string(),
  submittedOn: z.string(),
  approvedOn: z.string(),
  deniedOn: z.string(),
  cancelledOn: z.string(),
  initialNotificationSentOn: z.string(),
  thirtyDayNotificationSentOn: z.string(),
  sixtyDayNotificationSentOn: z.string(),
  ninetyDayNotificationSentOn: z.string(),
  onHoldNotificationSentOn: z.string(),
  transferredWithinGreOn: z.string(),
  clearanceNotificationSentOn: z.string(),
  interestedReceivedOn: z.string(),
  interestFromEnhancedReferralNote: z.string(),
  requestForSplReceivedOn: z.string(),
  approvedForSplOn: z.string(),
  marketedOn: z.string(),
  disposedOn: z.string(),
  offerAcceptedOn: z.string(),
  assessedOn: z.string(),
  adjustedOn: z.string(),
  preliminaryFormSignedOn: z.string(),
  finalFormSignedOn: z.string(),
  priorYearAdjustmentOn: z.string(),
  exemptionRequested: z.boolean(),
  exemptionRationale: z.string(),
  exemptionApprovedOn: z.string(),
  netBook: z.number(),
  market: z.number(),
  appraised: z.number(),
  assessed: z.number(),
  salesCost: z.number(),
  netProceeds: z.number(),
  programCost: z.number(),
  programCostNote: z.string(),
  gainLoss: z.number(),
  gainNote: z.string(),
  sppCapitalization: z.number(),
  gainBeforeSpl: z.number(),
  ocgFinancialStatement: z.number(),
  interestComponent: z.number(),
  loanTermsNote: z.string(),
  offerAmount: z.number(),
  saleWithLeaseInPlace: z.boolean(),
  priorYearAdjustment: z.boolean(),
  priorYearAdjustmentAmount: z.number(),
  adjustmentNote: z.string(),
  remediationNote: z.string(),
  closeOutNote: z.string(),
  plannedFutureUse: z.string(),
  realtor: z.string(),
  realtorRate: z.string(),
  realtorCommission: z.number(),
  preliminaryFormSignedBy: z.string(),
  finalFormSignedBy: z.string(),
  removalFromSplRequestOn: z.string(),
  removalFromSplApprovedOn: z.string(),
  removalFromSplRationale: z.string(),
  documentationNote: z.string(),
  salesHistoryNote: z.string(),
  comments: z.string(),
  notes: z.array(NoteSchema),
  properties: z.array(PropertySchema),
  tasks: z.array(TaskSchema),
  projectAgencyResponses: z.array(ProjectAgencyResponseSchema),
  statusHistory: z.array(StatusHistorySchema),
});

export type Project = z.infer<typeof ProjectSchema>;

const SnapshotSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  projectId: z.number(),
  project: ProjectSchema,
  snapshotOn: z.string(),
  netBook: z.number(),
  market: z.number(),
  assessed: z.number(),
  appraised: z.number(),
  salesCost: z.number(),
  netProceeds: z.number(),
  baselineIntegrity: z.number(),
  programCost: z.number(),
  gainLoss: z.number(),
  ocgFinancialStatement: z.number(),
  interestComponent: z.number(),
  saleWithLeaseInPlace: z.boolean(),
});

export type ProjectSnapshot = z.infer<typeof SnapshotSchema>;

export const ProjectReportSchema = z.object({
  createdOn: z.string(),
  updatedOn: z.string(),
  updatedByName: z.string(),
  updatedByEmail: z.string(),
  rowVersion: z.string(),
  id: z.number(),
  isFinal: z.boolean(),
  name: z.string(),
  from: z.string(),
  to: z.string(),
  reportType: z.string(),
  snapshots: z.array(SnapshotSchema),
});

export type ProjectReport = z.infer<typeof ProjectReportSchema>;
