import { IProjectAgencyResponse, IProjectNote, IProjectProperty, IProjectTask } from '.';

export interface IApiProject {
  id?: number;
  projectNumber: string;
  fiscalYear: number;
  name: string;
  description: string;
  properties: IProjectProperty[];
  projectAgencyResponses: IProjectAgencyResponse[];
  note: string;
  netBook: number | '';
  market: number | '';
  assessed: number | '';
  appraised?: number | '';
  publicNote: string;
  privateNote: string;
  exemptionRequested?: boolean;
  exemptionRationale?: string;
  exemptionApprovedOn?: Date | string;
  interestFromEnhancedReferralNote?: string;
  agencyId: number;
  statusId: number;
  statusCode?: string;
  tierLevelId: number;
  tasks: IProjectTask[];
  rowVersion?: string;
  approvedOn?: Date | string;
  deniedOn?: Date | string;
  cancelledOn?: Date | string;
  submittedOn?: Date | string;
  InitialNotificationSentOn?: Date | string;
  ThirtyDayNotificationSentOn?: Date | string;
  SixtyDayNoficationSentOn?: Date | string;
  NinetyDayNotificationSentOn?: Date | string;
  OnHoldNotificationSentOn?: Date | string;
  TransferredWithinGreOn?: Date | string;
  ClearanceNotificationSentOn?: Date | string;
  disposedOn?: Date | string;
  notes: IProjectNote[];
  sendNotifications?: boolean;
}
