---
title: "Compiler Error CS0019 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0019"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0019"
ms.assetid: 5a25be41-535b-4850-a230-9a385e01fd20
caps.latest.revision: 15
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0019
Operator 'operator' cannot be applied to operands of type 'type' and 'type'  
  
 A binary operator is applied to data types that do not support it. For example, you cannot use the [&#124;&#124;](../../../csharp/language-reference/operators/conditional-or-operator.md) operator on strings, you cannot use [+](../../../csharp/language-reference/operators/addition-operator.md) , [-](../../../csharp/language-reference/operators/subtraction-operator.md) , [\<](../../../csharp/language-reference/operators/less-than-operator.md) , or [>](../../../csharp/language-reference/operators/greater-than-operator.md) operators on [bool](../../../csharp/language-reference/keywords/bool.md) variables, and you cannot use the [==](../../../csharp/language-reference/operators/equality-comparison-operator.md) operator with a `struct` type unless the type explicitly overloads that operator.  
  
 If you encounter this error with a class type, it is because the class does not overload the operator. For more information, see [Overloadable Operators](../../../csharp/programming-guide/statements-expressions-operators/overloadable-operators.md).  
  
## Example  
 In the following example, CS0019 is generated in two places because [bool](../../../csharp/language-reference/keywords/bool.md) in C# is not convertible to [int](../../../csharp/language-reference/keywords/int.md). CS0019 also is generated when the subtraction operator is applied to a string. The addition operator (+) can be used with string operands because that operator is overloaded by the `String` class to perform string concatenation.  
  
```  
static void Main()  
{  
    bool result = true;  
    if (result > 0) //CS0019  
    {  
        // Do something.  
    }  
  
    int i = 1;  
    // You cannot compare an integer and a boolean value.  
    if (i == true) //CS0019  
    {  
        //Do something...  
    }  
  
    // The following use of == causes no error. It is the comparison of  
    // an integer and a boolean value that causes the error in the   
    // previous if statement.  
    if (result == true)  
    {  
        //Do something...  
    }  
  
    string s = "Just try to subtract me.";  
    float f = 100 - s; // CS0019  
}  
  
```  
  
## Example  
 In the following example, conditional logic must be specified outside the <xref:System.Diagnostics.ConditionalAttribute>. You can pass only one predefined symbol to the <xref:System.Diagnostics.ConditionalAttribute>.  
  
 The following sample generates CS0019.  
  
```  
// CS0019_a.cs  
// compile with: /target:library  
using System.Diagnostics;  
public class MyClass  
{  
   [ConditionalAttribute("DEBUG" || "TRACE")]   // CS0019  
   public void TestMethod() {}  
  
   // OK  
   [ConditionalAttribute("DEBUG"), ConditionalAttribute("TRACE")]  
   public void TestMethod2() {}  
}  
  
```  
  
## See Also  
 [Operators](../../../csharp/programming-guide/statements-expressions-operators/operators.md)   
 [Implicit Numeric Conversions Table](../../../csharp/language-reference/keywords/implicit-numeric-conversions-table.md)