---
title: "Compiler Error CS0731 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0731"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0731"
ms.assetid: b2df5d5c-b1cd-4620-881f-f5a492669784
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0731
The type forwarder for type 'type' in assembly 'assembly' causes a cycle  
  
 This error can only occur with improperly formed imported metadata. It cannot occur with only C# source.  
  
## Example  
 The following sample generates CS0731. The example consists of three files:  
  
 1. Circular.IL  
  
 2. Circular2.IL  
  
 3. CS0731.cs  
  
 First compile the .IL files as libraries, and then compile the .cs code referencing the two files.  
  
```  
// Circular.il  
// compile with: /DLL /out=Circular.dll  
.assembly extern circular2  
{  
  .ver 0:0:0:0  
}  
.assembly extern circular3  
{  
  .ver 0:0:0:0  
}  
.assembly extern mscorlib  
{  
  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )   // .z\V.4..  
  .ver 2:0:0:0  
}  
.assembly Circular  
{  
  .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )   
  .hash algorithm 0x00008004  
  .ver 0:0:0:0  
}  
.class extern forwarder Circular.Referenced.TypeForwarder  
{  
  .assembly extern circular2  
}  
.module Circular.dll  
// MVID: {880C2329-C915-42A0-83E9-9D10C3E6DBD0}  
.imagebase 0x00400000  
.file alignment 0x00000200  
.stackreserve 0x00100000  
.subsystem 0x0003       // WINDOWS_CUI  
.corflags 0x00000001    //  ILONLY  
// Image base: 0x04E40000  
// ======== CLASS MEMBERS DECLARATION =========  
.class public abstract auto ansi sealed beforefieldinit User  
       extends [mscorlib]System.Object  
{  
  .method public hidebysig static class [circular2]Circular.Referenced.TypeForwarder   
          F() cil managed  
  {  
    .maxstack  1  
    newobj     instance void [circular2]Circular.Referenced.TypeForwarder::.ctor()  
    ret  
  }  
}   
```  
  
```  
// Circular2.il  
// compile with: /DLL /out=Circular2.dll  
.assembly extern mscorlib  
{  
  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )   // .z\V.4..  
  .ver 2:0:0:0  
}  
.assembly extern Circular  
{  
  .ver 0:0:0:0  
}  
.assembly circular2  
{  
  .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )   
  .hash algorithm 0x00008004  
  .ver 0:0:0:0  
}  
.class extern forwarder Circular.Referenced.TypeForwarder  
{  
  .assembly extern Circular  
}  
.module circular2.dll  
// MVID: {8B3BE5C8-DBE1-49C4-BC72-DF35F0387C21}  
.imagebase 0x00400000  
.file alignment 0x00000200  
.stackreserve 0x00100000  
.subsystem 0x0003       //   WINDOWS_CUI  
.corflags 0x00000001    //  ILONLY  
// Image base: 0x04E40000  
```  
  
```  
// CS0731.cs  
// compile with: /reference:circular.dll /reference:circular2.dll  
// CS0731 expected  
class A {  
   public static void Main() {  
      User.F();  
   }  
}  
```