---
title: "Compiler Error CS1501 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1501"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1501"
ms.assetid: 99a59646-e2c8-4ee5-9785-4a2c1ae77458
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1501
No overload for method 'method' takes 'number' arguments  
  
 A call was made to a class method, but no definition of the method takes the specified number of arguments.  
  
## Example  
 The following sample generates CS1501.  
  
```cs  
using System;  
  
namespace ConsoleApplication1  
{  
    class Program  
    {  
        static void Main(string[] args)  
        {  
            ExampleClass ec = new ExampleClass();  
            ec.ExampleMethod();  
            ec.ExampleMethod(10);  
            // The following line causes compiler error CS1501 because   
            // ExampleClass does not contain an ExampleMethod that takes  
            // two arguments.  
            ec.ExampleMethod(10, 20);  
        }  
    }  
  
    // ExampleClass contains two overloads for ExampleMethod. One of them   
    // has no parameters and one has a single parameter.  
    class ExampleClass  
    {  
        public void ExampleMethod()  
        {  
            Console.WriteLine("Zero parameters");  
        }  
  
        public void ExampleMethod(int i)  
        {  
            Console.WriteLine("One integer parameter.");  
        }  
  
        //// To fix the error, you must add a method that takes two arguments.  
        //public void ExampleMethod (int i, int j)  
        //{  
        //    Console.WriteLine("Two integer parameters.");  
        //}  
    }  
}  
```