---
title: "Compiler Error CS1926 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1926"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1926"
ms.assetid: 58cc8385-8d92-4cee-8941-d05e128e3674
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1926
Error reading Win32 manifest file 'filename' -- 'error'.  
  
 This error is generated when the following conditions are true:  
  
1.  The **/win32manifest** option is specified either on the command line or by right-clicking the **Project** icon in **Solution Explorer**, pointing to **Add**, clicking **New Item**, and then clicking **Application Manifest File**.  
  
2.  The file is either corrupted or missing.  
  
## To correct this error  
  
1.  Remove the option.  
  
2.  Replace, repair, or regenerate the file.  
  
## Example  
 The following example generates CS1926 when it is compiled with a corrupted for missing win32 manifest file:  
  
```  
// cs1926.cs  
// Compile with: /win32manifest: ../../app.manifest  
// CS1926  
class Test  
{  
    public static int Main()  
    {  
        return 1;  
    }  
}   
```  
  
## See Also  
 [/win32manifest (C# Compiler Options)](../../../csharp/language-reference/compiler-options/win32manifest-compiler-option.md)