---
title: "Compiler Error CS0037 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0037"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0037"
ms.assetid: 1d34a71e-10a0-4fa8-9b94-343e69428c61
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0037
Cannot convert null to 'type' because it is a non-nullable value type  
  
 The compiler cannot assign null to a value type; null can only be assigned to a [reference type](../../csharp/language-reference/keywords/reference-types.md) or to a Nullable type. [struct](../../csharp/language-reference/keywords/struct.md) is a value type. For more information, see [Nullable Types](../../csharp/programming-guide/nullable-types/index.md).  
  
 The following sample generates CS0037:  
  
```  
// CS0037.cs  
public struct s  
{  
}  
  
class a  
{  
   public static void Main()  
   {  
      int i = null;   // CS0037  
      s ss = null;    // CS0037  
   }  
}  
```