---
title: "Compiler Error CS0118 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0118"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0118"
ms.assetid: 9a612432-6e56-4e9b-9d8c-7d7b43f58c1a
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0118
'construct1_name' is a 'construct1' but is used like a 'construct2'  
  
 The compiler detected a situation in which a construct was used in some erroneous way or a disallowed operation was tried on a construct. Some common examples include the following:  
  
-   A try to instantiate a namespace (instead of a class)  
  
-   A try to call a field (instead of a method)  
  
-   A try to use a type as a variable  
  
-   A try to use an extern alias as a type.  
  
 To resolve this error, make sure that the operation you are performing is valid for the type you are performing the operation on.  
  
## Example  
 The following sample generates CS0118.  
  
```  
// CS0118.cs  
// compile with: /target:library  
namespace MyNamespace  
{  
   class MyClass  
   {  
      // MyNamespace not a class  
      MyNamespace ix = new MyNamespace ();   // CS0118  
   }  
}  
```