---
title: "Compiler Warning (level 1) CS0197 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0197"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0197"
ms.assetid: 2b5b1b8d-ce13-4bd7-b80a-abb80e9f79ad
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS0197
Passing 'argument' as ref or out or taking its address may cause a runtime exception because it is a field of a marshal-by-reference class  
  
 Any class that derives, directly or indirectly, from <xref:System.MarshalByRefObject> is a marshal-by-reference class. Such a class can be marshaled by reference across process and machine boundaries. Thus, instances of this class could be proxies to remote objects. You cannot pass a field of a proxy object as [ref](../../csharp/language-reference/keywords/ref.md) or [out](../../csharp/language-reference/keywords/out.md). So, you cannot pass fields of such a class as `ref` or `out`, unless the instance is [this](../../csharp/language-reference/keywords/this.md), which can not be a proxy object.  
  
## Example  
 The following sample generates CS0197.  
  
```  
// CS0197.cs  
// compile with: /W:1  
class X : System.MarshalByRefObject  
{  
   public int i;  
}  
  
class M  
{  
   public int i;  
   static void AddSeventeen(ref int i)  
   {  
      i += 17;  
   }  
  
   static void Main()  
   {  
      X x = new X();  
      x.i = 12;  
      AddSeventeen(ref x.i);   // CS0197  
  
      // OK  
      M m = new M();  
      m.i = 12;  
      AddSeventeen(ref m.i);  
   }  
}  
```