---
title: "Compiler Error CS0281 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0281"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0281"
ms.assetid: 3b886510-6e4d-45bc-b885-3ab7f6b6b2c6
caps.latest.revision: 18
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0281
Friend access was granted to 'AssemblyName1', but the output assembly is named 'AssemblyName2'. Try adding a reference to 'AssemblyName1' or changing the output assembly name to match.  
  
 Friend access is a new common language runtime (CLR) feature that enables an assembly to see another assembly's non-public types. This error occurs when the assembly granting friend access specifies the wrong name for the grantee assembly. For more information, see [Friend Assemblies](http://msdn.microsoft.com/library/df0c70ea-2c2a-4bdc-9526-df951ad2d055).  
  
## Example  
 The following sequence of code samples will generate CS0281.  
  
 The files used to create the strong named assemblies are generated as follows:  
  
-   sn -d CS0281.snk  
  
-   sn -k CS0281.snk  
  
-   sn -i CS0281.snk CS0281.snk  
  
-   sn -pc CS0281.snk key.publickey  
  
-   sn -tp key.publickey  
  
```  
// CS0281.cs  
// compile with: /target:library /keyfile:CS0281.snk  
public class A {}  
```  
  
## Example  
  
```  
// CS0281_b.cs  
// compile with: /target:library /keyfile:CS0281.snk /reference:CS0281.dll  
[assembly:System.Runtime.CompilerServices.InternalsVisibleTo("CS0281 , PublicKey=00240000048000009400000006020000002400005253413100040000010001004b2d4d56af7c50be2fcbbf97cb880b9e73ad84467a587191fef63aadc118a96cecf9d508cd679c907b6e20f71684300bdc2c0a851019af0c96b29bf8f1339753276041aefd67db46139e6348b3a12f29537b4dc6c2c19829df2c9ed6803f3c63c3b84cfa2728849386aea575c543a5f70fa85793d2946f15f7fe1ccb0c5e8fe0")]  
class B : A {}  
```  
  
## Example  
 The following sample generates CS0281.  
  
 Notice that this sample creates an output file with the same name as the output file in the first sample. To resolve, do not change the assembly attributes of the component and add class C.  
  
```  
// CS0281_c.cs  
// compile with: /target:library /out:CS0281.dll /keyfile:CS0281.snk /reference:CS0281_b.dll  
// CS0281 expected  
[assembly:System.Reflection.AssemblyVersion("3")]  
[assembly:System.Reflection.AssemblyCulture("en-us")]  
class C : B {}  
public class A {}  
```