---
title: "Compiler Error CS0315 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0315"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0315"
ms.assetid: 9bb1cab3-1dca-4467-978b-1ab310901a70
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0315
The type 'valueType' cannot be used as type parameter 'T' in the generic type or method 'TypeorMethod\<T>'. There is no boxing conversion from 'valueType' to 'referenceType'.  
  
 This error occurs when you constrain a generic type to a particular class, and try to construct an instance of that class by using a value type that cannot be implicitly boxed to it.  
  
## To correct this error  
  
1.  One solution is to redefine the struct as a class.  
  
## Example  
 The following example generates CS0315:  
  
```  
// cs0315.cs  
public class ClassConstraint { }  
public struct ViolateClassConstraint { }  
  
public class Gen<T> where T : ClassConstraint  
{         
}  
public class Test  
{  
    public static int Main()  
    {  
        Gen<ViolateClassConstraint> g = new Gen<ViolateClassConstraint>(); //CS0315  
        return 1;  
    }  
}  
```  
  
## See Also  
 [Constraints on Type Parameters](../../csharp/programming-guide/generics/constraints-on-type-parameters.md)   
 [Boxing and Unboxing](../../csharp/programming-guide/types/boxing-and-unboxing.md)