---
title: "Compiler Error CS0403 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0403"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0403"
ms.assetid: 6e5d55ce-d6bf-419d-aded-aaa2e5963bb6
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0403
Cannot convert null to type parameter 'name' because it could be a non-nullable value type. Consider using default('T') instead.  
  
 You cannot assign null to the unknown type named because it might be a value type, which does not allow null assignment. If your generic class is not intended to accept value types, use the class type constraint. If it can accept value types, such as the built-in types, you may be able to replace the assignment to null with the expression `default(T)`, as shown in the following example.  
  
## Example  
 The following sample generates CS0403.  
  
```  
// CS0403.cs  
// compile with: /target:library  
class C<T>  
{  
   public void f()  
   {  
      T t = null;  // CS0403  
      T t2 = default(T);   // OK  
    }  
}  
  
class D<T> where T : class   
{  
   public void f()  
   {  
      T t = null;  // OK  
    }  
}  
```