---
title: "Compiler Error CS0662 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0662"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0662"
ms.assetid: 836fa15e-3bf3-4af5-8acf-072d7d731dcd
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0662
'method' cannot specify only Out attribute on a ref parameter. Use both In and Out attributes, or neither.  
  
 An interface method has a parameter that uses [ref](../../csharp/language-reference/keywords/ref.md) with just the [Out](xref:System​.Runtime​.InteropServices.OutAttribute) attribute. A `ref` parameter that uses the **Out** attribute must also use the [In](xref:System​.Runtime​.InteropServices.InAttribute) attribute.  
  
 The following sample generates CS0662:  
  
```cs
// CS0662.cs  
using System.Runtime.InteropServices;  
  
interface I  
{  
   void method([Out] ref int i);   // CS0662  
   // try one of the following lines instead  
   // void method(ref int i);  
   // void method([Out, In]ref int i);  
}  
  
class test  
{  
   public static void Main()  
   {  
   }  
}  
```