---
title: "Compiler Error CS0825 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0825"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0825"
ms.assetid: 49393d23-ec5f-4b44-a3fd-7e0a95ac0edd
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0825
The contextual keyword 'var' may only appear within a local variable declaration.  
  
 Implicit typing with the `var` keyword can only be applied to variables at local method scope.  
  
## To correct this error  
  
1.  If the variable belongs at class scope, give it an explicit type.  Otherwise move it inside the method where it will be used.  
  
## Example  
 The following code generates CS0825 because `var` is used on a class field:  
  
```  
// cs0825.cs  
class Test  
{  
    private var myField; //CS0825  
  
    static int Main()  
    {  
        var a = 1; // var is OK here  
        return -1;  
    }  
}  
```  
  
## See Also  
 [Implicitly Typed Local Variables](../../csharp/programming-guide/classes-and-structs/implicitly-typed-local-variables.md)