---
title: "Compiler Error CS1931 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1931"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1931"
ms.assetid: c0071c3d-ae11-4073-87df-508150daef68
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1931
The range variable 'variable' conflicts with a previous declaration of 'variable'.  
  
 The declaration of a range variable, just like every other declaration, must have an identifier which is unique within the variable's declaration space.  
  
## To correct this error  
  
1.  Give the range variable a unique name.  
  
## Example  
 The following code generates CS1931 because the identifier `x` is used both as a local variable in `Main` and as the range variable in the query expression:  
  
```  
// cs1931.cs  
class Test  
    {  
        static void Main()  
        {  
            int x = 1;  
            var y = from x in Enumerable.Range(1, 100) // CS1931  
                    select x;  
        }  
    }  
```  
  
## See Also  
 [LINQ Query Expressions](../../csharp/programming-guide/linq-query-expressions/index.md)