---
title: "Compiler Error CS1939 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1939"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1939"
ms.assetid: 9a7cdd48-3d45-473a-a799-c7771ef8158d
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1939
Cannot pass the range variable 'name' as an out or ref parameter.  
  
 A range variable is a read-only variable that is introduced in a query expression and serves as an identifier for each successive element in a source sequence. Because it cannot be modified in any way, there is no point in passing it by `ref` or `out`. Therefore, both operations are not valid.  
  
## To correct this error  
  
1.  Pass the range variable by value.  
  
## Example  
 The following example generates CS1939:  
  
```  
// cs1939.cs  
using System.Linq;  
class Test  
{  
    public static void F(ref int i)  
    {  
    }  
    public static void Main()  
    {  
        var list = new int[] { 0, 1, 2, 3, 4, 5 };  
        var q = from x in list  
                let k = x  
                select Test.F(ref x); // CS1939  
    }  
}  
```