# [Classes and Structs](index.md)
## [Classes](classes.md)
## [Objects](objects.md)
## [Structs](structs.md)
### [Using Structs](using-structs.md)
## [Inheritance](inheritance.md)
## [Polymorphism](polymorphism.md)
### [Versioning with the Override and New Keywords](versioning-with-the-override-and-new-keywords.md)
### [Knowing When to Use Override and New Keywords](knowing-when-to-use-override-and-new-keywords.md)
### [How to: Override the ToString Method](how-to-override-the-tostring-method.md)
## [Abstract and Sealed Classes and Class Members](abstract-and-sealed-classes-and-class-members.md)
### [How to: Define Abstract Properties](how-to-define-abstract-properties.md)
## [Static Classes and Static Class Members](static-classes-and-static-class-members.md)
## [Members](members.md)
## [Access Modifiers](access-modifiers.md)
## [Fields](fields.md)
## [Constants](constants.md)
### [How to: Define Constants in C#](how-to-define-constants.md)
## [Properties](properties.md)
### [Using Properties](using-properties.md)
### [Interface Properties](interface-properties.md)
### [Restricting Accessor Accessibility](restricting-accessor-accessibility.md)
### [How to: Declare and Use Read Write Properties](how-to-declare-and-use-read-write-properties.md)
### [Auto-Implemented Properties](auto-implemented-properties.md)
### [How to: Implement a Lightweight Class with Auto-Implemented Properties](how-to-implement-a-lightweight-class-with-auto-implemented-properties.md)
## [Methods](methods.md)
### [Passing Parameters](passing-parameters.md)
#### [Passing Value-Type Parameters](passing-value-type-parameters.md)
#### [Passing Reference-Type Parameters](passing-reference-type-parameters.md)
#### [How to: Know the Difference Between Passing a Struct and Passing a Class Reference to a Method](how-to-know-the-difference-passing-a-struct-and-passing-a-class-to-a-method.md)
### [Implicitly Typed Local Variables](implicitly-typed-local-variables.md)
#### [How to: Use Implicitly Typed Local Variables and Arrays in a Query Expression](how-to-use-implicitly-typed-local-variables-and-arrays-in-a-query-expression.md)
### [Extension Methods](extension-methods.md)
#### [How to: Implement and Call a Custom Extension Method](how-to-implement-and-call-a-custom-extension-method.md)
#### [How to: Create a New Method for an Enumeration](how-to-create-a-new-method-for-an-enumeration.md)
### [Named and Optional Arguments](named-and-optional-arguments.md)
#### [How to: Use Named and Optional Arguments in Office Programming](how-to-use-named-and-optional-arguments-in-office-programming.md)
## [Constructors](constructors.md)
### [Using Constructors](using-constructors.md)
### [Instance Constructors](instance-constructors.md)
### [Private Constructors](private-constructors.md)
### [Static Constructors](static-constructors.md)
### [How to: Write a Copy Constructor](how-to-write-a-copy-constructor.md)
## [Destructors](destructors.md)
## [Object and Collection Initializers](object-and-collection-initializers.md)
### [How to: Initialize Objects by Using an Object Initializer](how-to-initialize-objects-by-using-an-object-initializer.md)
### [How to: Initialize a Dictionary with a Collection Initializer](how-to-initialize-a-dictionary-with-a-collection-initializer.md)
## [How to: Access a Collection Class with foreach](how-to-access-a-collection-class-with-foreach.md)
## [Nested Types](nested-types.md)
## [Partial Classes and Methods](partial-classes-and-methods.md)
## [Anonymous Types](anonymous-types.md)
### [How to: Return Subsets of Element Properties in a Query](how-to-return-subsets-of-element-properties-in-a-query.md)
