---
title: "Advanced LINQ to XML Programming (C#) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
ms.assetid: 2e012d40-532b-49ea-b1fc-152e616bdfa3
caps.latest.revision: 3
author: "BillWagner"
ms.author: "wiwagn"

---
# Advanced LINQ to XML Programming (C#)
This section provides information that will only be applicable to advanced developers in certain [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] scenarios.  
  
## In This Section  
  
|Topic|Description|  
|-----------|-----------------|  
|[LINQ to XML Annotations](../../../../csharp/programming-guide/concepts/linq/linq-to-xml-annotations.md)|Describes how to add annotations to [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] nodes and attributes.|  
|[LINQ to XML Events (C#)](../../../../csharp/programming-guide/concepts/linq/linq-to-xml-events.md)|Describes how to write event handlers for events that occur when you alter an XML tree.|  
|[Programming with Nodes (C#)](../../../../csharp/programming-guide/concepts/linq/programming-with-nodes.md)|Describes how to query and manipulate nodes at a finer level of granularity than elements and attributes.|  
|[Mixed Declarative Code/Imperative Code Bugs (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/mixed-declarative-code-imperative-code-bugs-linq-to-xml.md)|Describes the problems that appear when you mix declarative code (queries) with imperative code (code that modifies the XML tree).|  
|[How to: Stream XML Fragments with Access to Header Information (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-stream-xml-fragments-with-access-to-header-information.md)|Describes how to stream XML fragments from an <xref:System.Xml.XmlReader>. You can use this technique to control the memory footprint of your application.|  
|[How to: Perform Streaming Transform of Large XML Documents (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-perform-streaming-transform-of-large-xml-documents.md)|Describes how to stream XML from an <xref:System.Xml.XmlReader>, transform the XML fragment, and stream the output using <xref:System.Xml.Linq.XStreamingElement>.|  
|[How to: Read and Write an Encoded Document (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-read-and-write-an-encoded-document.md)|Describes how to read and write XML documents that are encoded.|  
|[Using XSLT to Transform an XML Tree (C#)](../../../../csharp/programming-guide/concepts/linq/using-xslt-to-transform-an-xml-tree.md)|Describes how to transform an XML tree using XSLT.|  
|[How to: Use Annotations to Transform LINQ to XML Trees in an XSLT Style (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-use-annotations-to-transform-linq-to-xml-trees-in-an-xslt-style.md)|Describes how annotations can be used to facilitate transforms of an XML tree.|  
|[Serializing Object Graphs that Contain XElement Objects (C#)](../../../../csharp/programming-guide/concepts/linq/serializing-object-graphs-that-contain-xelement-objects.md)|Describes how to serialize object graphs that contain <xref:System.Xml.Linq.XElement> and <xref:System.Xml.Linq.XDocument> objects.|  
|[WPF Data Binding with LINQ to XML](https://docs.microsoft.com/visualstudio/designers/wpf-data-binding-with-linq-to-xml)|Describes how to use LINQ to XML as the data source for data binding in Windows Presentation Foundation applications.|  
  
## See Also  
 [Programming Guide (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/programming-guide-linq-to-xml.md)