---
title: "Pointer Expressions (C# Programming Guide) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "expressions [C#], pointer types"
  - "pointer expressions [C#]"
ms.assetid: 3e7d9db3-20e9-4493-9c99-53c3214d19e5
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Pointer Expressions (C# Programming Guide)
In this section, the following pointer expressions are discussed:  
  
 [Obtaining the Value of a Variable](../../../csharp/programming-guide/unsafe-code-pointers/how-to-obtain-the-value-of-a-pointer-variable.md)  
  
 [Obtaining the Address of a Variable](../../../csharp/programming-guide/unsafe-code-pointers/how-to-obtain-the-address-of-a-variable.md)  
  
 [How to: Access a Member with a Pointer](../../../csharp/programming-guide/unsafe-code-pointers/how-to-access-a-member-with-a-pointer.md)  
  
 [How to: Access an Array Element with a Pointer](../../../csharp/programming-guide/unsafe-code-pointers/how-to-access-an-array-element-with-a-pointer.md)  
  
 [Manipulating Pointers](../../../csharp/programming-guide/unsafe-code-pointers/manipulating-pointers.md)  
  
## See Also  
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [Pointer Conversions](../../../csharp/programming-guide/unsafe-code-pointers/pointer-conversions.md)   
 [Pointer types](../../../csharp/programming-guide/unsafe-code-pointers/pointer-types.md)   
 [Types](../../../csharp/language-reference/keywords/types.md)   
 [unsafe](../../../csharp/language-reference/keywords/unsafe.md)   
 [fixed Statement](../../../csharp/language-reference/keywords/fixed-statement.md)   
 [stackalloc](../../../csharp/language-reference/keywords/stackalloc.md)