---
title: "C# Walkthroughs | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "walkthroughs [C#]"
  - "walkthroughs [Visual Studio], Visual C#"
  - "Visual C#, walkthroughs"
ms.assetid: 2d07b972-ef69-4676-9aef-e1784728e1ff
caps.latest.revision: 28
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# C# Walkthroughs
Walkthroughs give step-by-step instructions for common scenarios, which makes them a good place to start learning about the product or a particular feature area.  
  
 This section contains links to C# programming walkthroughs.  
  
## In This Section  

 [Accessing the Web by Using Async and Await](./programming-guide/concepts/async/walkthrough-accessing-the-web-by-using-async-and-await.md)  
 Shows how to create an asynchronous solution by using [async](../csharp/language-reference/keywords/async.md) and [await](../csharp/language-reference/keywords/await.md), introduced in [!INCLUDE[vs_dev11_long](../csharp/includes/vs_dev11_long_md.md)].  
  
 [Creating a Windows Runtime Component in C# or Visual Basic and Calling it from JavaScript](https://msdn.microsoft.com/library/windows/apps/hh779077.aspx)  
 Shows how to create a [!INCLUDE[wrt](../csharp/includes/wrt_md.md)] type, package it in a [!INCLUDE[wrt](../csharp/includes/wrt_md.md)] component, and then call the component from a [!INCLUDE[win8_appname_long](../csharp/includes/win8_appname_long_md.md)] app that's built for Windows by using JavaScript.  
  
 [Office Programming (C# and Visual Basic)](../csharp/programming-guide/interop/walkthrough-office-programming.md)  
 Shows how to create an Excel workbook and a Word document by using C# and Visual Basic.  
  
 [Creating and Using Dynamic Objects (C# and Visual Basic)](../csharp/programming-guide/types/walkthrough-creating-and-using-dynamic-objects.md)  
 Shows how to create a custom object that dynamically exposes the contents of a text file, and how to create a project that uses the `IronPython` library.  
   
 [Authoring a Composite Control with Visual C#](https://msdn.microsoft.com/library/a6h7e207.aspx)  
 Demonstrates creating a simple composite control and extending its functionality through inheritance.  
  
 [Creating a Windows Forms Control that Takes Advantage of Visual Studio Design-Time Features](https://msdn.microsoft.com/library/35ea88wb.aspx)  
 Illustrates how to create a custom designer for a custom control.  
  
 [Inheriting from a Windows Forms Control with Visual C#](https://msdn.microsoft.com/library/5h0k2e6x.aspx)  
 Demonstrates creating a simple inherited button control. This button inherits functionality from the standard Windows Forms button and exposes a custom member.  
  
 [Debugging Custom Windows Forms Controls at Design Time](https://msdn.microsoft.com/library/5ytx0z24.aspx)  
 Describes how to debug the design-time behavior of your custom control.

 [Performing Common Tasks Using Smart Tags on Windows Forms Controls](https://msdn.microsoft.com/library/xhz359sc.aspx)  
 Demonstrates some of the commonly performed tasks such as adding or removing a tab on a `TabControl`, docking a control to its parent, and changing the orientation of a `SplitContainer` control.  
  
 [Writing Queries in C# (LINQ)](../csharp/programming-guide/concepts/linq/walkthrough-writing-queries-linq.md)  
 Demonstrates the C# language features that are used to write [!INCLUDE[vbteclinq](../csharp/includes/vbteclinq_md.md)] query expressions.  
  
 [Manipulating Data (C#) (LINQ to SQL)](https://msdn.microsoft.com/library/bb386927.aspx)  
 Describes a [!INCLUDE[vbtecdlinq](../csharp/includes/vbtecdlinq_md.md)] scenario for adding, modifying, and deleting data in a database.  
  
 [Simple Object Model and Query (C#) (LINQ to SQL)](https://msdn.microsoft.com/library/bb386940.aspx)  
 Demonstrates how to create an entity class and a simple query to filter the entity class.  
  
 [Using Only Stored Procedures (C#) (LINQ to SQL)](https://msdn.microsoft.com/library/bb399407.aspx)  
 Demonstrates how to use LINQ to SQL to access data by executing only stored procedures.  
  
 [Querying Across Relationships (C#) (LINQ to SQL)](https://msdn.microsoft.com/library/bb386951.aspx)  
 Demonstrates the use of [!INCLUDE[vbtecdlinq](../csharp/includes/vbtecdlinq_md.md)] associations to represent foreign-key relationships in a database.  

 [Writing a Visualizer in C#](https://docs.microsoft.com/visualstudio/debugger/walkthrough-writing-a-visualizer-in-csharp)  
 Shows how to write a simple visualizer by using C#.  
  
## Related Sections  
 [Deployment Samples and Walkthroughs](https://docs.microsoft.com/visualstudio/deployment/clickonce-deployment-samples-and-walkthroughs)  
 Provides step-by-step examples of common deployment scenarios.  
  
## See Also  
 [C# Programming Guide](../csharp/programming-guide/index.md)   
 [Visual Studio Samples](https://docs.microsoft.com/visualstudio/ide/visual-studio-samples)