---
title: Regular expression examples
description: Regular expression examples
keywords: .NET, .NET Core
author: stevehoag
ms.author: shoag
ms.date: 07/28/2016
ms.topic: article
ms.prod: .net
ms.technology: dotnet-standard
ms.devlang: dotnet
ms.assetid: 232b9f8d-464b-4e40-98bb-d69c32059bc0
---

# Regular expression examples

This section contains code examples that illustrate the use of regular expressions in common applications.

## In This Section

[Regular expression example: scanning for HREFs](scanning.md) - Provides an example that searches an input string and prints out all the href="…" values and their locations in the string.

[Regular expression example: changing date formats](changing-formats.md) - Provides an example that replaces dates in the form mm/dd/yy with dates in the form dd-mm-yy.

[How to: extract a protocol and port number from a URL](extract-protocol.md) - Provides an example that extracts a protocol and port number from a string that contains a URL. For example, "http://www.contoso.com:8080/letters/readme.html" returns "http:8080".

[How to: strip invalid characters from a string](strip-characters.md) - Provides an example that strips invalid non-alphanumeric characters from a string.

[How to: verify that strings are in valid email format](verify-format.md) - Provides an example that you can use to verify that a string is in valid email format.

[.NET regular expressions](regular-expressions.md) - Provides an overview of the programming language aspect of regular expressions.

[The regular expression object model](object-model.md) - Describes the regular expression classes contained in the `System.Text.RegularExpression` namespace and provides examples of their use.

[Details of regular expression behavior](regex-behavior.md) - Provides information about the capabilities and behavior of .NET regular expressions.

[Regular expression language - quick reference](quick-ref.md) - Provides information on the set of characters, operators, and constructs that you can use to define regular expressions.

## Reference

[System.Text.RegularExpressions](xref:System.Text.RegularExpressions) - Provides class library reference information for the .NET `System.Text.RegularExpressions` namespace.
