---
title: "Accessing the Keyboard (Visual Basic) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "keyboards, accessing [Visual Basic]"
  - "My.Computer.Keyboard object, tasks"
  - "keystrokes"
  - "CapsLock property"
ms.assetid: aa37d54c-5c98-4b44-b98a-c26d2a03c038
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Accessing the Keyboard (Visual Basic)
The `My.Computer.Keyboard` object provides properties for accessing the current state of the keyboard, such as what keys are currently pressed, and provides a method to send keystrokes to the active window.  
  
## Tasks  
 This table lists tasks associated with the `My.Computer.Keyboard` object and points to topics demonstrating how to perform each task.  
  
|To|See|  
|--------|---------|  
|Determine whether CAPS LOCK is on|<xref:Microsoft.VisualBasic.Devices.Keyboard.CapsLock%2A>|  
|Determine whether the SHIFT key is down|<xref:Microsoft.VisualBasic.Devices.Keyboard.ShiftKeyDown%2A>|  
|Determine whether the ALT key is down|<xref:Microsoft.VisualBasic.Devices.Keyboard.AltKeyDown%2A>|  
|Determine whether the CTRL key is down|<xref:Microsoft.VisualBasic.Devices.Keyboard.CtrlKeyDown%2A>|  
|Determine whether NUM LOCK is on|<xref:Microsoft.VisualBasic.Devices.Keyboard.NumLock%2A>|  
|Determine whether SCROLL LOCK is on|<xref:Microsoft.VisualBasic.Devices.Keyboard.ScrollLock%2A>|  
|Start an application and send it keystrokes|[How to: Start an Application and Send it Keystrokes (Visual Basic)](../../../../visual-basic/developing-apps/programming/computer-resources/how-to-start-an-application-and-send-it-keystrokes.md)|  
  
## See Also  
 <xref:Microsoft.VisualBasic.Devices.Keyboard>   
 <xref:System.Windows.Forms.Keys?displayProperty=fullName>