---
title: "Declarations and Constants Summary (Visual Basic) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "constants"
  - "declaring constants, keywords"
  - "declarations, Visual Basic language elements"
ms.assetid: 79d64f3e-941d-4d39-bc5b-79f225d5be6e
caps.latest.revision: 14
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Declarations and Constants Summary (Visual Basic)
Visual Basic language keywords and run-time library members are organized by purpose and use.  
  
|Action|Language element|  
|------------|----------------------|  
|Assign a value.|[Get](../../../visual-basic/language-reference/statements/get-statement.md), [Property](../../../visual-basic/language-reference/statements/property-statement.md)|  
|Declare variables or constants.|[Const](../../../visual-basic/language-reference/statements/const-statement.md), [Dim](../../../visual-basic/language-reference/statements/dim-statement.md), [Private](../../../visual-basic/language-reference/modifiers/private.md), [Protected](../../../visual-basic/language-reference/modifiers/protected.md), [Public](../../../visual-basic/language-reference/modifiers/public.md), [Shadows](../../../visual-basic/language-reference/modifiers/shadows.md), [Shared](../../../visual-basic/language-reference/modifiers/shared.md), [Static](../../../visual-basic/language-reference/modifiers/static.md)|  
|Declare a class, delegate, enumeration, module, namespace, or structure.|[Class](../../../visual-basic/language-reference/statements/class-statement.md), [Delegate](../../../visual-basic/language-reference/statements/delegate-statement.md), [Enum](../../../visual-basic/language-reference/statements/enum-statement.md), [Module](../../../visual-basic/language-reference/statements/module-statement.md), [Namespace](../../../visual-basic/language-reference/statements/namespace-statement.md), [Structure](../../../visual-basic/language-reference/statements/structure-statement.md)|  
|Create objects.|<xref:Microsoft.VisualBasic.Interaction.CreateObject%2A>, <xref:Microsoft.VisualBasic.Interaction.GetObject%2A>, [New](../../../visual-basic/language-reference/operators/new-operator.md)|  
|Get information about an object.|[GetType](../../../visual-basic/language-reference/operators/gettype-operator.md), <xref:Microsoft.VisualBasic.Information.IsArray%2A>, <xref:Microsoft.VisualBasic.Information.IsDate%2A>, <xref:Microsoft.VisualBasic.Information.IsDBNull%2A>, <xref:Microsoft.VisualBasic.Information.IsError%2A>, <xref:Microsoft.VisualBasic.Information.IsNothing%2A>, <xref:Microsoft.VisualBasic.Information.IsNumeric%2A>, <xref:Microsoft.VisualBasic.Information.IsReference%2A>, <xref:Microsoft.VisualBasic.Information.SystemTypeName%2A>, <xref:Microsoft.VisualBasic.Information.TypeName%2A>, <xref:Microsoft.VisualBasic.Information.VarType%2A>, <xref:Microsoft.VisualBasic.Information.VbTypeName%2A>|  
|Refer to the current object.|[Me](../../../visual-basic/programming-guide/program-structure/me-my-mybase-and-myclass.md)|  
|Require explicit variable declarations.|[Option Explicit](../../../visual-basic/language-reference/statements/option-explicit-statement.md), [Option Strict](../../../visual-basic/language-reference/statements/option-strict-statement.md)|  
|Handle events.|[AddHandler](../../../visual-basic/language-reference/statements/addhandler-statement.md), [Event](../../../visual-basic/language-reference/statements/event-statement.md), [RaiseEvent](../../../visual-basic/language-reference/statements/raiseevent-statement.md), [RemoveHandler](../../../visual-basic/language-reference/statements/removehandler-statement.md)|  
|Implement inheritance.|[Inherits](../../../visual-basic/language-reference/statements/inherits-statement.md), [MustInherit](../../../visual-basic/language-reference/modifiers/mustinherit.md), [MustOverride](../../../visual-basic/language-reference/modifiers/mustoverride.md), [MyBase](../../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md), [MyClass](../../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md), [New](../../../visual-basic/language-reference/operators/new-operator.md), [NotInheritable](../../../visual-basic/language-reference/modifiers/notinheritable.md), [NotOverridable](../../../visual-basic/language-reference/modifiers/notoverridable.md), [Overloads](../../../visual-basic/language-reference/modifiers/overloads.md), [Overridable](../../../visual-basic/language-reference/modifiers/overridable.md), [Overrides](../../../visual-basic/language-reference/modifiers/overrides.md)|  
  
## See Also  
 [Keywords](../../../visual-basic/language-reference/keywords/index.md)   
 [Visual Basic Runtime Library Members](../../../visual-basic/language-reference/runtime-library-members.md)