---
title: "Bounds can be specified only for the top-level array when initializing an array of arrays | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32014"
  - "vbc32014"
helpviewer_keywords: 
  - "BC32014"
ms.assetid: d8d7155d-82d1-4a25-b9bb-1883e1586383
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Bounds can be specified only for the top-level array when initializing an array of arrays
An array initialization for a jagged array (array of arrays) sets the initial length of one of the lower levels. You can specify the length of only the top-level array in the array declaration statement.  
  
 **Error ID:** BC32014  
  
## To correct this error  
  
1.  Remove the length specification from all but the top-level array.  
  
2.  Set the initial length of lower-level arrays in subsequent assignment statements using the `New` keyword.  
  
## See Also  
 [NOTINBUILD  an Array Variable](http://msdn.microsoft.com/en-us/c2da78bd-6928-46ba-805f-44f819dfaf93)   
 [NOTINBUILD Jagged Arrays in Visual Basic](http://msdn.microsoft.com/en-us/05c12439-ee8f-4fef-ba75-b35402b67ab9)   
 [New Operator](../../visual-basic/language-reference/operators/new-operator.md)