---
title: "&#39;=&#39; expected (Let or Set assignment) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32020"
  - "vbc32020"
helpviewer_keywords: 
  - "BC32020"
ms.assetid: 1b12f082-e502-4524-9326-b9b372670243
caps.latest.revision: 12
author: "stevehoag"
ms.author: "shoag"

---
# &#39;=&#39; expected (Let or Set assignment)
A `Let` or `Set` assignment statement does not include an equal sign (`=`).  
  
 The `Let` and `Set` assignment statements are not supported in the current version of Visual Basic. The compiler can determine the type of assignment from the data type of the programming element that is to receive the value. A *value type* assignment replaces the `Let` statement, and a *reference type* assignment replaces the former `Set` statement.  
  
 The [Set Statement](../../visual-basic/language-reference/statements/set-statement.md) is used in property definitions and has no relation to the `Set` assignment statement.  
  
 **Error ID:** BC32020  
  
## To correct this error  
  
-   Use a standard assignment statement, including an equal sign (`=`) and a value to be assigned to the variable or property.  
  
## See Also  
 [Programming Element Support Changes Summary](http://msdn.microsoft.com/en-us/0483590a-6309-449c-a2fa-effa26a03b95)   
 [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md)   
 [NotInBuild:Assignment Statements](http://msdn.microsoft.com/en-us/eb4f91e9-fbbf-45ca-b21d-e8ae069de4f9)