---
title: "Cannot implement &#39;&lt;interfacename1&gt;.&lt;membername&gt;&#39; because its implementation could conflict with the implementation for &#39;&lt;interfacename2&gt;.&lt;membername&gt;&#39; for some type arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32125"
  - "vbc32125"
helpviewer_keywords: 
  - "BC32125"
ms.assetid: 74321d27-4ff8-440c-b5de-d67e98fff274
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Cannot implement &#39;&lt;interfacename1&gt;.&lt;membername&gt;&#39; because its implementation could conflict with the implementation for &#39;&lt;interfacename2&gt;.&lt;membername&gt;&#39; for some type arguments
A class implements more than one generic interface, one of which inherits from another, and two implementations of an interface member could conflict for certain values of type arguments.  
  
 The following statements can generate this error.  
  
```  
Public Interface iFace1(Of t)  
    Sub testSub()  
End Interface  
Public Interface iFace2(Of u)  
    Inherits iFace1(Of u)  
End Interface  
Public Class testClass(Of y, z)  
    Implements iFace1(Of y), iFace2(Of z)  
    Public Sub testSuby() Implements iFace1(Of y).testSub  
    End Sub  
    Public Sub testSubz() Implements iFace1(Of z).testSub  
    End Sub  
End Class  
```  
  
 Because `iFace2` inherits from `iFace1` using its own type parameter (`u`), `testClass` would implement two versions of `iFace1.testSub` with identical signatures if the same type argument were passed to `y` and `z`. This would produce an ambiguity about which version to access.  
  
 **Error ID:** BC32125  
  
## To correct this error  
  
-   Change the inheritance structure of the interfaces so that `iFace1` could not be implemented with two different type arguments.  
  
     -or-  
  
-   Remove from the `Implements` statement one of the interfaces resulting in the implementation conflict.  
  
## See Also  
 [Class Statement](../../visual-basic/language-reference/statements/class-statement.md)   
 [Interface Statement](../../visual-basic/language-reference/statements/interface-statement.md)   
 [Implements Statement](../../visual-basic/language-reference/statements/implements-statement.md)   
 [NOT IN BUILD: Implements Keyword and Implements Statement](http://msdn.microsoft.com/en-us/b96560f7-6413-480f-a1e2-f80253bab5be)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)