---
title: "&#39;Using&#39; resource variable type can not be array type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36012"
  - "bc36012"
helpviewer_keywords: 
  - "BC36012"
ms.assetid: f98c54b0-6ede-48b6-aa31-438664c219f3
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Using&#39; resource variable type can not be array type
A `Using` statement specifies an array variable for a resource.  
  
 The <xref:System.Array> class does not implement the <xref:System.IDisposable> interface, so the `Using` block cannot call the <xref:System.IDisposable.Dispose%2A> method on an array resource.  
  
 **Error ID:** BC36012  
  
## To correct this error  
  
-   Use a different type of system resource in the `Using` block.  
  
## See Also  
 [Using Statement](../../visual-basic/language-reference/statements/using-statement.md)   
 [How to: Dispose of a System Resource](../../visual-basic/programming-guide/language-features/control-flow/how-to-dispose-of-a-system-resource.md)   
 [NOTINBUILD Overview of Arrays in Visual Basic](http://msdn.microsoft.com/en-us/ca50e2f2-b4d2-4c57-9169-9abbcc3392d8)