---
title: "&#39;ByRef&#39; parameter &lt;parametername&gt; cannot be used in a query expression | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36533"
  - "bc36533"
helpviewer_keywords: 
  - "BC36533"
ms.assetid: 8067ac87-dd6b-4869-87d0-8a4ce272de41
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;ByRef&#39; parameter &lt;parametername&gt; cannot be used in a query expression
A parameter included in a LINQ query is a pointer type. Parameters used in query expressions cannot be passed by reference.  
  
 **Error ID:** BC36533  
  
## To correct this error  
  
1.  Declare a new variable and assign the value of the new variable to a copy of the value that is passed by reference. Use the copied variable in the LINQ query. The following is an example:  
  
```vb  
Sub RunQuery(ByVal collection As List(Of Integer), _  
             ByRef filterValue As Integer)  
    Dim fv = filterValue  
    Dim queryResult = From num In collection _  
                      Where num < fv  
End Sub  
```  
  
## To correct this error  
  
1.  Replace the `ByRef` keyword with the `ByVal` keyword for the parameter used in the query.  
  
## See Also  
 [Differences Between Passing an Argument By Value and By Reference](../../visual-basic/programming-guide/language-features/procedures/differences-between-passing-an-argument-by-value-and-by-reference.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)