---
title: "Anonymous type property &#39;&lt;propertyname&gt;&#39; cannot be used in the definition of a lambda expression within the same initialization list | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36549"
  - "bc36549"
helpviewer_keywords: 
  - "BC36549"
ms.assetid: 6d04692a-957a-41ce-a19c-fcb06a186d1a
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Anonymous type property &#39;&lt;propertyname&gt;&#39; cannot be used in the definition of a lambda expression within the same initialization list
Properties defined in the initialization list of an anonymous type cannot be part of a lambda expression definition in the same list. For example, in the following code, property `Num` cannot be included in the definition of `LambdaFun`.  
  
```vb  
' Not valid.  
'Dim anon = New With {.Num = 4, .LambdaFun = Function() .Num > 0}  
```  
  
 **Error ID:** BC36549  

## To correct this error  
  
1.  Consider splitting the anonymous type into two parts:  
  
```vb  
Dim anon1 = New With {.Num = 4}  
Dim anon2 = New With {.LambdaFun = Function() anon1.Num > 0}  
' - or -  
Dim anon3 = New With {.lambdaFun = Function(n As Integer) n > 0}  
Console.WriteLine((anon2.LambdaFun)())  
Console.WriteLine(anon3.lambdaFun(anon1.Num))  
anon1.Num = -5  
Console.WriteLine((anon2.LambdaFun)())  
Console.WriteLine(anon3.lambdaFun(anon1.Num))  
```  
  
Note that if you declare `anon1.Num` as a `Key` property, its value cannot be changed.  
  
2.  An alternative is to use a regular function statement to access the anonymous type property:  
  
```vb  
Function testNum(ByVal n As Integer) As Boolean  
    Return n > 0  
End Function  
Console.WriteLine(testNum(anon1.Num))  
```  
  
3.  Similarly, you can use a lambda function that is defined outside the anonymous type:  
  
```vb  
Dim lambdaFun1 = Function() anon1.Num > 0  
Dim lambdaFun2 = Function(n As Integer) n > 0  
```  
  
## See Also  
 [Lambda Expressions](../../visual-basic/programming-guide/language-features/procedures/lambda-expressions.md)   
 [Anonymous Types](../../visual-basic/programming-guide/language-features/objects-and-classes/anonymous-types.md)