---
title: "&#39;Equals&#39; cannot compare a value of type &lt;type1&gt; with a value of type &lt;type2&gt; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36621"
  - "bc36621"
helpviewer_keywords: 
  - "BC36621"
ms.assetid: bd40bf57-3a12-407a-8622-7e428850c77c
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Equals&#39; cannot compare a value of type &lt;type1&gt; with a value of type &lt;type2&gt;
An `Equals` operator in a `Join` or `Group Join` clause has attempted to compare one data type to another in a way that is not defined. An example of this is a comparison of a `Boolean` value to a `Date` type.  
  
 **Error ID:** BC36621  
  
## To correct this error  
  
-   Make sure that the values on each side of the `Equals` operator can be converted to a common data type. Some options for accomplishing this are:  
  
    -   Use the `CType` function to convert one or more of the values to a specific type.  
  
    -   Use the <xref:System.Convert> class or conversion methods to convert one or more of the values to a common, immutable type.  
  
    -   Convert the values to strings by using the `ToString` method.  
  
## See Also  
 [CType Function](../../visual-basic/language-reference/functions/ctype-function.md)   
 [Type Conversions in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/type-conversions.md)   
 [Join Clause](../../visual-basic/language-reference/queries/join-clause.md)   
 [Group Join Clause](../../visual-basic/language-reference/queries/group-join-clause.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)