---
title: "Option Strict On requires each lambda expression parameter to be declared with an &#39;As&#39; clause if its type cannot be inferred | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36642"
  - "vbc36642"
helpviewer_keywords: 
  - "BC36642"
ms.assetid: 2aaa62b8-49c9-4ae8-b0f5-08e3f0b5ad10
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Option Strict On requires each lambda expression parameter to be declared with an &#39;As&#39; clause if its type cannot be inferred
You have declared a parameter in a lambda expression without using an `As` clause, with `Option Strict` on.  
  
```  
' Not valid when Option Strict is on.  
' Dim increment1 = Function (n) n + 1  
```  
  
 The previous declaration is valid if the type of `n` can be inferred. For example, if you are assigning the previous lambda expression to a function delegate, `Del`:  
  
```  
Delegate Function Del(ByVal p As Integer) As Integer  
```  
  
 Now the type of `n` can be inferred from parameter `p`:  
  
```  
Dim increment2 as Del = Function(n) n + 1  
```  
  
 **Error ID:** BC36642  
  
## To correct this error  
  
-   Add an `As` clause to the parameter declaration:  
  
    ```  
    Dim increment3 = Function (n As Integer) n + 1  
    ```  
  
## See Also  
 [Lambda Expressions](../../visual-basic/programming-guide/language-features/procedures/lambda-expressions.md)