---
title: "Statement recursively calls the containing &#39;AddHandler&#39; for event &#39;&lt;eventname&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc41998"
  - "vbc41998"
helpviewer_keywords: 
  - "BC41998"
ms.assetid: 4375b191-fbd9-4e93-b9bb-9159d533ddf6
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Statement recursively calls the containing &#39;AddHandler&#39; for event &#39;&lt;eventname&gt;&#39;
The statements in the `AddHandler` accessor of an event definition must not reference the event directly.  
  
 The recommended approach is to store the list of the event's handlers as a private field in the class, structure, or module that defined the event. For more information, see [How to: Declare Custom Events To Avoid Blocking](../../visual-basic/programming-guide/language-features/events/how-to-declare-custom-events-to-avoid-blocking.md) and [How to: Declare Custom Events To Conserve Memory](../../visual-basic/programming-guide/language-features/events/how-to-declare-custom-events-to-conserve-memory.md).  
  
 **Error ID:** BC41998  
  
## To correct this error  
  
-   Rewrite the event definition to avoid recursion.  
  
## See Also  
 [AddHandler - delete](http://msdn.microsoft.com/en-us/fc464cf8-582c-48a6-a9c2-185c4c3d5ff8)   
 [Event Statement](../../visual-basic/language-reference/statements/event-statement.md)   
 [How to: Declare Custom Events To Avoid Blocking](../../visual-basic/programming-guide/language-features/events/how-to-declare-custom-events-to-avoid-blocking.md)   
 [How to: Declare Custom Events To Conserve Memory](../../visual-basic/programming-guide/language-features/events/how-to-declare-custom-events-to-conserve-memory.md)