---
title: "Visual Basic Programming Guide | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "Visual Basic code, language guide"
  - "Visual Basic, programming in"
  - "Visual Basic, language reference"
ms.assetid: 640e5796-2796-433c-af37-4d2a2334895b
caps.latest.revision: 19
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic Programming Guide
As with any modern programming language, [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] supports many common programming constructs and language elements. This guide describes all the major elements of programming with [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
## In This Section  
 [Program Structure and Code Conventions](../../visual-basic/programming-guide/program-structure/program-structure-and-code-conventions.md)  
 Contains documentation on the basic structure and code conventions of [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)], such as naming conventions, comments in code, and limitations within [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Visual Basic Language Features](../../visual-basic/programming-guide/language-features/index.md)  
 Provides links to topics that introduce and discuss important features of [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)], including LINQ and XML literals.  
  
 [COM Interop](../../visual-basic/programming-guide/com-interop/index.md)  
 Explains the interoperability issues associated with creating and using component object model (COM) objects with [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
## Related Sections  
 [Visual Basic Language Reference](../../visual-basic/language-reference/index.md)  
 Provides reference information about various aspects of [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] programming.  
  
 [Visual Basic Command-Line Compiler](../../visual-basic/reference/command-line-compiler/index.md)  
 Offers information on using the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] command-line compiler, the compiler options, and the Keyword Upgrade tool.