#! /usr/bin/env bash
set -e

SCRIPT_ROOT=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd -P)
MANIFEST_FILE=../../deploy/examples/multus-validation.yaml
SED=${SCRIPT_ROOT}/../../build/sed-in-place
if [[ ${SKIP_GEN} = true ]]; then
  echo "SKIP_GEN is set, skipping manifest  generation"
  exit
fi
OUT_FILE="${SCRIPT_ROOT}/${MANIFEST_FILE}"
TMP_FILE="$(mktemp)"

START_MARKER='# THE BELOW HELP TEXT IS AUTO-GENERATED BY `make docs`$'
END_MARKER='# THE ABOVE HELP TEXT IS AUTO-GENERATED BY `make docs`$'

go run ${SCRIPT_ROOT}/../../cmd/rook/*.go multus validation run --help | awk '{print "# "$0}' | sed -e 's/[ \t]*$//' > ${TMP_FILE}

${SED} -e "/$START_MARKER/,/$END_MARKER/{ /$START_MARKER/{ p ; r $TMP_FILE

  }; /$END_MARKER/p; d; }"  ${OUT_FILE}

rm -f ${TMP_FILE}

