/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephCOSIDrivers implements CephCOSIDriverInterface
type FakeCephCOSIDrivers struct {
	Fake *FakeCephV1
	ns   string
}

var cephcosidriversResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephcosidrivers"}

var cephcosidriversKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephCOSIDriver"}

// Get takes name of the cephCOSIDriver, and returns the corresponding cephCOSIDriver object, and an error if there is any.
func (c *FakeCephCOSIDrivers) Get(ctx context.Context, name string, options v1.GetOptions) (result *cephrookiov1.CephCOSIDriver, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephcosidriversResource, c.ns, name), &cephrookiov1.CephCOSIDriver{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCOSIDriver), err
}

// List takes label and field selectors, and returns the list of CephCOSIDrivers that match those selectors.
func (c *FakeCephCOSIDrivers) List(ctx context.Context, opts v1.ListOptions) (result *cephrookiov1.CephCOSIDriverList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephcosidriversResource, cephcosidriversKind, c.ns, opts), &cephrookiov1.CephCOSIDriverList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephCOSIDriverList{ListMeta: obj.(*cephrookiov1.CephCOSIDriverList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephCOSIDriverList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephCOSIDrivers.
func (c *FakeCephCOSIDrivers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephcosidriversResource, c.ns, opts))

}

// Create takes the representation of a cephCOSIDriver and creates it.  Returns the server's representation of the cephCOSIDriver, and an error, if there is any.
func (c *FakeCephCOSIDrivers) Create(ctx context.Context, cephCOSIDriver *cephrookiov1.CephCOSIDriver, opts v1.CreateOptions) (result *cephrookiov1.CephCOSIDriver, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephcosidriversResource, c.ns, cephCOSIDriver), &cephrookiov1.CephCOSIDriver{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCOSIDriver), err
}

// Update takes the representation of a cephCOSIDriver and updates it. Returns the server's representation of the cephCOSIDriver, and an error, if there is any.
func (c *FakeCephCOSIDrivers) Update(ctx context.Context, cephCOSIDriver *cephrookiov1.CephCOSIDriver, opts v1.UpdateOptions) (result *cephrookiov1.CephCOSIDriver, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephcosidriversResource, c.ns, cephCOSIDriver), &cephrookiov1.CephCOSIDriver{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCOSIDriver), err
}

// Delete takes name of the cephCOSIDriver and deletes it. Returns an error if one occurs.
func (c *FakeCephCOSIDrivers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephcosidriversResource, c.ns, name), &cephrookiov1.CephCOSIDriver{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephCOSIDrivers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephcosidriversResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephCOSIDriverList{})
	return err
}

// Patch applies the patch and returns the patched cephCOSIDriver.
func (c *FakeCephCOSIDrivers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *cephrookiov1.CephCOSIDriver, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephcosidriversResource, c.ns, name, pt, data, subresources...), &cephrookiov1.CephCOSIDriver{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCOSIDriver), err
}
