/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephObjectStoreLister helps list CephObjectStores.
// All objects returned here must be treated as read-only.
type CephObjectStoreLister interface {
	// List lists all CephObjectStores in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStore, err error)
	// CephObjectStores returns an object that can list and get CephObjectStores.
	CephObjectStores(namespace string) CephObjectStoreNamespaceLister
	CephObjectStoreListerExpansion
}

// cephObjectStoreLister implements the CephObjectStoreLister interface.
type cephObjectStoreLister struct {
	indexer cache.Indexer
}

// NewCephObjectStoreLister returns a new CephObjectStoreLister.
func NewCephObjectStoreLister(indexer cache.Indexer) CephObjectStoreLister {
	return &cephObjectStoreLister{indexer: indexer}
}

// List lists all CephObjectStores in the indexer.
func (s *cephObjectStoreLister) List(selector labels.Selector) (ret []*v1.CephObjectStore, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectStore))
	})
	return ret, err
}

// CephObjectStores returns an object that can list and get CephObjectStores.
func (s *cephObjectStoreLister) CephObjectStores(namespace string) CephObjectStoreNamespaceLister {
	return cephObjectStoreNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephObjectStoreNamespaceLister helps list and get CephObjectStores.
// All objects returned here must be treated as read-only.
type CephObjectStoreNamespaceLister interface {
	// List lists all CephObjectStores in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStore, err error)
	// Get retrieves the CephObjectStore from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephObjectStore, error)
	CephObjectStoreNamespaceListerExpansion
}

// cephObjectStoreNamespaceLister implements the CephObjectStoreNamespaceLister
// interface.
type cephObjectStoreNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephObjectStores in the indexer for a given namespace.
func (s cephObjectStoreNamespaceLister) List(selector labels.Selector) (ret []*v1.CephObjectStore, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectStore))
	})
	return ret, err
}

// Get retrieves the CephObjectStore from the indexer for a given namespace and name.
func (s cephObjectStoreNamespaceLister) Get(name string) (*v1.CephObjectStore, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephobjectstore"), name)
	}
	return obj.(*v1.CephObjectStore), nil
}
