namespace :loomio do
  task generate_test_error: :environment do
    raise "this is a generated test error"
  end

  task :version do
    puts Loomio::Version.current
  end

  task generate_static_error_pages: :environment do
    [400, 404, 410, 417, 422, 429, 500].each do |code|
      File.open("public/#{code}.html", "w") do |f|
        f << "<!-- This file is automatically generated by rake loomio:generate_static_error_pages -->\n"
        f << "<!-- Don't make changes here; they will be overwritten. -->\n"
        f << ApplicationController.new.render_to_string(
          template: "errors/#{code}",
          layout: "errors"
        )
      end
    end
  end

  task hourly_tasks: :environment do
    PollService.delay.expire_lapsed_polls
    PollService.delay.publish_closing_soon
    SendMissedYesterdayEmailJob.perform_later
    ResendIgnoredInvitationsJob.perform_later
    LocateUsersAndGroupsJob.perform_later
    if (Time.now.hour == 0)
      # daily tasks
      UsageReportService.send
    end
  end

  task migrate_attachments: :environment do
    MigrateAttachmentService.migrate!(attachments: Attachment.where(attachable_type: [
      "Discussion",
      "Poll",
      "Comment",
      "Outcome"
    ]))
  end

  task resend_ignored_invitations: :environment do
    InvitationService.resend_ignored(send_count: 1, since: 1.day.ago)
    InvitationService.resend_ignored(send_count: 2, since: 3.days.ago)
  end

  task generate_error: :environment do
    raise "this is an exception to test exception handling"
  end

  task tag_and_measure_cohorts: :environment do
    CohortService.tag_groups
  end

  task notify_clients_of_update: :environment do
    MessageChannelService.publish_data({ version: Loomio::Version.current }, to: GlobalMessageChannel.instance)
  end
end
