# System.Net.Http.Headers

``` diff
+namespace System.Net.Http.Headers {
+    public class AuthenticationHeaderValue {
+        public AuthenticationHeaderValue(string scheme);
+        public AuthenticationHeaderValue(string scheme, string parameter);
+        public string Parameter { get; }
+        public string Scheme { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static AuthenticationHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out AuthenticationHeaderValue parsedValue);
+    }
+    public class CacheControlHeaderValue {
+        public CacheControlHeaderValue();
+        public ICollection<NameValueHeaderValue> Extensions { get; }
+        public Nullable<TimeSpan> MaxAge { get; set; }
+        public bool MaxStale { get; set; }
+        public Nullable<TimeSpan> MaxStaleLimit { get; set; }
+        public Nullable<TimeSpan> MinFresh { get; set; }
+        public bool MustRevalidate { get; set; }
+        public bool NoCache { get; set; }
+        public ICollection<string> NoCacheHeaders { get; }
+        public bool NoStore { get; set; }
+        public bool NoTransform { get; set; }
+        public bool OnlyIfCached { get; set; }
+        public bool Private { get; set; }
+        public ICollection<string> PrivateHeaders { get; }
+        public bool ProxyRevalidate { get; set; }
+        public bool Public { get; set; }
+        public Nullable<TimeSpan> SharedMaxAge { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static CacheControlHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out CacheControlHeaderValue parsedValue);
+    }
+    public class ContentDispositionHeaderValue {
+        protected ContentDispositionHeaderValue(ContentDispositionHeaderValue source);
+        public ContentDispositionHeaderValue(string dispositionType);
+        public Nullable<DateTimeOffset> CreationDate { get; set; }
+        public string DispositionType { get; set; }
+        public string FileName { get; set; }
+        public string FileNameStar { get; set; }
+        public Nullable<DateTimeOffset> ModificationDate { get; set; }
+        public string Name { get; set; }
+        public ICollection<NameValueHeaderValue> Parameters { get; }
+        public Nullable<DateTimeOffset> ReadDate { get; set; }
+        public Nullable<long> Size { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static ContentDispositionHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out ContentDispositionHeaderValue parsedValue);
+    }
+    public class ContentRangeHeaderValue {
+        public ContentRangeHeaderValue(long length);
+        public ContentRangeHeaderValue(long from, long to);
+        public ContentRangeHeaderValue(long from, long to, long length);
+        public Nullable<long> From { get; }
+        public bool HasLength { get; }
+        public bool HasRange { get; }
+        public Nullable<long> Length { get; }
+        public Nullable<long> To { get; }
+        public string Unit { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static ContentRangeHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out ContentRangeHeaderValue parsedValue);
+    }
+    public class EntityTagHeaderValue {
+        public EntityTagHeaderValue(string tag);
+        public EntityTagHeaderValue(string tag, bool isWeak);
+        public static EntityTagHeaderValue Any { get; }
+        public bool IsWeak { get; }
+        public string Tag { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static EntityTagHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out EntityTagHeaderValue parsedValue);
+    }
+    public sealed class HttpContentHeaders : HttpHeaders {
+        public ICollection<string> Allow { get; }
+        public ContentDispositionHeaderValue ContentDisposition { get; set; }
+        public ICollection<string> ContentEncoding { get; }
+        public ICollection<string> ContentLanguage { get; }
+        public Nullable<long> ContentLength { get; set; }
+        public Uri ContentLocation { get; set; }
+        public byte[] ContentMD5 { get; set; }
+        public ContentRangeHeaderValue ContentRange { get; set; }
+        public MediaTypeHeaderValue ContentType { get; set; }
+        public Nullable<DateTimeOffset> Expires { get; set; }
+        public Nullable<DateTimeOffset> LastModified { get; set; }
+    }
+    public abstract class HttpHeaders : IEnumerable, IEnumerable<KeyValuePair<string, IEnumerable<string>>> {
+        protected HttpHeaders();
+        public void Add(string name, IEnumerable<string> values);
+        public void Add(string name, string value);
+        public void Clear();
+        public bool Contains(string name);
+        public IEnumerator<KeyValuePair<string, IEnumerable<string>>> GetEnumerator();
+        public IEnumerable<string> GetValues(string name);
+        public bool Remove(string name);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override string ToString();
+        public bool TryAddWithoutValidation(string name, IEnumerable<string> values);
+        public bool TryAddWithoutValidation(string name, string value);
+        public bool TryGetValues(string name, out IEnumerable<string> values);
+    }
+    public sealed class HttpHeaderValueCollection<T> : ICollection<T>, IEnumerable, IEnumerable<T> where T : class {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public void Add(T item);
+        public void Clear();
+        public bool Contains(T item);
+        public void CopyTo(T[] array, int arrayIndex);
+        public IEnumerator<T> GetEnumerator();
+        public void ParseAdd(string input);
+        public bool Remove(T item);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override string ToString();
+        public bool TryParseAdd(string input);
+    }
+    public sealed class HttpRequestHeaders : HttpHeaders {
+        public HttpHeaderValueCollection<MediaTypeWithQualityHeaderValue> Accept { get; }
+        public HttpHeaderValueCollection<StringWithQualityHeaderValue> AcceptCharset { get; }
+        public HttpHeaderValueCollection<StringWithQualityHeaderValue> AcceptEncoding { get; }
+        public HttpHeaderValueCollection<StringWithQualityHeaderValue> AcceptLanguage { get; }
+        public AuthenticationHeaderValue Authorization { get; set; }
+        public CacheControlHeaderValue CacheControl { get; set; }
+        public HttpHeaderValueCollection<string> Connection { get; }
+        public Nullable<bool> ConnectionClose { get; set; }
+        public Nullable<DateTimeOffset> Date { get; set; }
+        public HttpHeaderValueCollection<NameValueWithParametersHeaderValue> Expect { get; }
+        public Nullable<bool> ExpectContinue { get; set; }
+        public string From { get; set; }
+        public string Host { get; set; }
+        public HttpHeaderValueCollection<EntityTagHeaderValue> IfMatch { get; }
+        public Nullable<DateTimeOffset> IfModifiedSince { get; set; }
+        public HttpHeaderValueCollection<EntityTagHeaderValue> IfNoneMatch { get; }
+        public RangeConditionHeaderValue IfRange { get; set; }
+        public Nullable<DateTimeOffset> IfUnmodifiedSince { get; set; }
+        public Nullable<int> MaxForwards { get; set; }
+        public HttpHeaderValueCollection<NameValueHeaderValue> Pragma { get; }
+        public AuthenticationHeaderValue ProxyAuthorization { get; set; }
+        public RangeHeaderValue Range { get; set; }
+        public Uri Referrer { get; set; }
+        public HttpHeaderValueCollection<TransferCodingWithQualityHeaderValue> TE { get; }
+        public HttpHeaderValueCollection<string> Trailer { get; }
+        public HttpHeaderValueCollection<TransferCodingHeaderValue> TransferEncoding { get; }
+        public Nullable<bool> TransferEncodingChunked { get; set; }
+        public HttpHeaderValueCollection<ProductHeaderValue> Upgrade { get; }
+        public HttpHeaderValueCollection<ProductInfoHeaderValue> UserAgent { get; }
+        public HttpHeaderValueCollection<ViaHeaderValue> Via { get; }
+        public HttpHeaderValueCollection<WarningHeaderValue> Warning { get; }
+    }
+    public sealed class HttpResponseHeaders : HttpHeaders {
+        public HttpHeaderValueCollection<string> AcceptRanges { get; }
+        public Nullable<TimeSpan> Age { get; set; }
+        public CacheControlHeaderValue CacheControl { get; set; }
+        public HttpHeaderValueCollection<string> Connection { get; }
+        public Nullable<bool> ConnectionClose { get; set; }
+        public Nullable<DateTimeOffset> Date { get; set; }
+        public EntityTagHeaderValue ETag { get; set; }
+        public Uri Location { get; set; }
+        public HttpHeaderValueCollection<NameValueHeaderValue> Pragma { get; }
+        public HttpHeaderValueCollection<AuthenticationHeaderValue> ProxyAuthenticate { get; }
+        public RetryConditionHeaderValue RetryAfter { get; set; }
+        public HttpHeaderValueCollection<ProductInfoHeaderValue> Server { get; }
+        public HttpHeaderValueCollection<string> Trailer { get; }
+        public HttpHeaderValueCollection<TransferCodingHeaderValue> TransferEncoding { get; }
+        public Nullable<bool> TransferEncodingChunked { get; set; }
+        public HttpHeaderValueCollection<ProductHeaderValue> Upgrade { get; }
+        public HttpHeaderValueCollection<string> Vary { get; }
+        public HttpHeaderValueCollection<ViaHeaderValue> Via { get; }
+        public HttpHeaderValueCollection<WarningHeaderValue> Warning { get; }
+        public HttpHeaderValueCollection<AuthenticationHeaderValue> WwwAuthenticate { get; }
+    }
+    public class MediaTypeHeaderValue {
+        protected MediaTypeHeaderValue(MediaTypeHeaderValue source);
+        public MediaTypeHeaderValue(string mediaType);
+        public string CharSet { get; set; }
+        public string MediaType { get; set; }
+        public ICollection<NameValueHeaderValue> Parameters { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static MediaTypeHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out MediaTypeHeaderValue parsedValue);
+    }
+    public sealed class MediaTypeWithQualityHeaderValue : MediaTypeHeaderValue {
+        public MediaTypeWithQualityHeaderValue(string mediaType);
+        public MediaTypeWithQualityHeaderValue(string mediaType, double quality);
+        public Nullable<double> Quality { get; set; }
+        public static new MediaTypeWithQualityHeaderValue Parse(string input);
+        public static bool TryParse(string input, out MediaTypeWithQualityHeaderValue parsedValue);
+    }
+    public class NameValueHeaderValue {
+        protected NameValueHeaderValue(NameValueHeaderValue source);
+        public NameValueHeaderValue(string name);
+        public NameValueHeaderValue(string name, string value);
+        public string Name { get; }
+        public string Value { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static NameValueHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out NameValueHeaderValue parsedValue);
+    }
+    public class NameValueWithParametersHeaderValue : NameValueHeaderValue {
+        protected NameValueWithParametersHeaderValue(NameValueWithParametersHeaderValue source);
+        public NameValueWithParametersHeaderValue(string name);
+        public NameValueWithParametersHeaderValue(string name, string value);
+        public ICollection<NameValueHeaderValue> Parameters { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static new NameValueWithParametersHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out NameValueWithParametersHeaderValue parsedValue);
+    }
+    public class ProductHeaderValue {
+        public ProductHeaderValue(string name);
+        public ProductHeaderValue(string name, string version);
+        public string Name { get; }
+        public string Version { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static ProductHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out ProductHeaderValue parsedValue);
+    }
+    public class ProductInfoHeaderValue {
+        public ProductInfoHeaderValue(ProductHeaderValue product);
+        public ProductInfoHeaderValue(string comment);
+        public ProductInfoHeaderValue(string productName, string productVersion);
+        public string Comment { get; }
+        public ProductHeaderValue Product { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static ProductInfoHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out ProductInfoHeaderValue parsedValue);
+    }
+    public class RangeConditionHeaderValue {
+        public RangeConditionHeaderValue(DateTimeOffset date);
+        public RangeConditionHeaderValue(EntityTagHeaderValue entityTag);
+        public RangeConditionHeaderValue(string entityTag);
+        public Nullable<DateTimeOffset> Date { get; }
+        public EntityTagHeaderValue EntityTag { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static RangeConditionHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out RangeConditionHeaderValue parsedValue);
+    }
+    public class RangeHeaderValue {
+        public RangeHeaderValue();
+        public RangeHeaderValue(Nullable<long> from, Nullable<long> to);
+        public ICollection<RangeItemHeaderValue> Ranges { get; }
+        public string Unit { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static RangeHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out RangeHeaderValue parsedValue);
+    }
+    public class RangeItemHeaderValue {
+        public RangeItemHeaderValue(Nullable<long> from, Nullable<long> to);
+        public Nullable<long> From { get; }
+        public Nullable<long> To { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class RetryConditionHeaderValue {
+        public RetryConditionHeaderValue(DateTimeOffset date);
+        public RetryConditionHeaderValue(TimeSpan delta);
+        public Nullable<DateTimeOffset> Date { get; }
+        public Nullable<TimeSpan> Delta { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static RetryConditionHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out RetryConditionHeaderValue parsedValue);
+    }
+    public class StringWithQualityHeaderValue {
+        public StringWithQualityHeaderValue(string value);
+        public StringWithQualityHeaderValue(string value, double quality);
+        public Nullable<double> Quality { get; }
+        public string Value { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static StringWithQualityHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out StringWithQualityHeaderValue parsedValue);
+    }
+    public class TransferCodingHeaderValue {
+        protected TransferCodingHeaderValue(TransferCodingHeaderValue source);
+        public TransferCodingHeaderValue(string value);
+        public ICollection<NameValueHeaderValue> Parameters { get; }
+        public string Value { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static TransferCodingHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out TransferCodingHeaderValue parsedValue);
+    }
+    public sealed class TransferCodingWithQualityHeaderValue : TransferCodingHeaderValue {
+        public TransferCodingWithQualityHeaderValue(string value);
+        public TransferCodingWithQualityHeaderValue(string value, double quality);
+        public Nullable<double> Quality { get; set; }
+        public static new TransferCodingWithQualityHeaderValue Parse(string input);
+        public static bool TryParse(string input, out TransferCodingWithQualityHeaderValue parsedValue);
+    }
+    public class ViaHeaderValue {
+        public ViaHeaderValue(string protocolVersion, string receivedBy);
+        public ViaHeaderValue(string protocolVersion, string receivedBy, string protocolName);
+        public ViaHeaderValue(string protocolVersion, string receivedBy, string protocolName, string comment);
+        public string Comment { get; }
+        public string ProtocolName { get; }
+        public string ProtocolVersion { get; }
+        public string ReceivedBy { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static ViaHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out ViaHeaderValue parsedValue);
+    }
+    public class WarningHeaderValue {
+        public WarningHeaderValue(int code, string agent, string text);
+        public WarningHeaderValue(int code, string agent, string text, DateTimeOffset date);
+        public string Agent { get; }
+        public int Code { get; }
+        public Nullable<DateTimeOffset> Date { get; }
+        public string Text { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static WarningHeaderValue Parse(string input);
+        public override string ToString();
+        public static bool TryParse(string input, out WarningHeaderValue parsedValue);
+    }
+}
```

