# .NET Core 2.0.0 Preview 2 Release Notes - 6/28/2017

.NET Core 2.0.0 Preview 2 and SDK 2.0.0 Preview 2 are available for download and testing.

* [Getting Started](https://dotnet.microsoft.com/download/dotnet)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.0-preview2-download.md)

The .NET Core SDK 2.0.0 Preview 2 includes .NET Core 2.0.0 Preview 2 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.0.0 Preview 2, the following command will show that you're running version `2.0.0-preview2-006497` of the tools.

`dotnet --version`

**Note** that if you want to use .NET Core 2.0.0 Preview 2 with Visual Studio 2017 15.3, you need to install the SDK.

A [number of improvements](2.0.0-preview2-commit.md) have been made since Preview 1 by an [incredible list of folks](2.0.0-preview2-contributor.md). You can see details for other areas of the release in the [.NET Blog](https://blogs.msdn.microsoft.com/dotnet/2017/06/28/announcing-net-core-2-0-preview-2/) and have a look at [.NET Core 2.0.0 Preview 2 Known Issues](2.0.0-preview2-known-issues.md) document as there are a few things to be aware of before installing.

You're feedback is important and appreciated. We've created [dotnet/core #711](https://github.com/dotnet/core/issues/711) for your questions and comments.

## .NET Core 2.0.0 Preview 2 Highlights

If you missed Preview 1, see those [release notes](2.0.0-preview1.md) for earlier highlights.

### Platform updates in Preview 2

We have an exciting addition to the supported platform line-up with SUSE. Debian and Fedora have released updates recently which are also supported beginning with Preview 2.

* [SUSE Linux Enterprise Server 12 SP2](https://www.suse.com/products/server/)
* [Debian 9](https://www.debian.org/News/2017/20170617)
* [Fedora 25 and 26 (beta)](https://getfedora.org)

#### High Sierra

Testing has begun on macOS High Sierra to ensure compatibility when .NET Core 2.0 releases later this year.

### Installer Package Name Changes

We received much feedback that our names and versions were confusing and generally messy. Great discussions were had with contributors to craft a plan which is implemented in Preview 2. You can see the conversation and details in [dotnet/designs/issues/2](https://github.com/dotnet/designs/issues/2) and [dotnet/core-setup/issues/1599](https://github.com/dotnet/core-setup/issues/1599).

### Server Hosting Bundles

Because the Runtime Package Store contains crossgen'ed files for a specific release, the hosting bundles will now install side-by-side. This will allow for previous applications to retain the performance benefits while applications targeting new Core versions will at the same time make use of the updated Store.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.0-preview2 images.

### WCF

The [WCF release page](https://github.com/dotnet/wcf/releases/tag/v2.0.0-preview2) has details on fixes from the WCF team.

## ASP.NET Core

* Please see the [ASP.NET Core announcement](https://blogs.msdn.microsoft.com/webdev/2017/06/28/introducing-asp-net-core-2-0-preview-2) for highlights on work from ASP.NET Core, MVC, Entity Framework Core and others.