# .NET Core 2.1.613

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.613
* .NET Core Runtime 2.1.20
* ASP.NET Core 2.1.20

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.20/2.1.20.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.613](#downloads) |
| Windows | Visual Studio 2017 | [2.1.516](2.1.20.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.20-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.20/2.1.20.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.20-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.20-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/



[//]: # ( Runtime 2.1.20)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dda6ad2b-9ac3-433d-ad09-7b4e2f9d2c68/56b428eb350634acb00cc28d0d36bf08/dotnet-runtime-2.1.20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ba465b-6aaa-408c-9573-2880260eeba8/4c109a758b52266f4686f606c98a7cf1/dotnet-runtime-2.1.20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86cfc62a-1098-4f7c-8de8-77a7aee0befa/58261743b6417923d7e062fc1186f875/dotnet-runtime-2.1.20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cf1759a-46ee-449d-b5eb-3f855245c4c7/44b34ab2d89ac06fc621ad695498e689/dotnet-runtime-2.1.20-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5a175623-89a4-4cf5-b7ae-46d323f02df1/2c3bafdc54c9da352b2f1bd3fc515875/dotnet-runtime-2.1.20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37f67936-d74a-4b1b-9c62-b71aa95972e5/c6eabaf75a472a4a88d56a8ee0206d1f/dotnet-runtime-2.1.20-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c396ecda-9f9f-4631-b984-6114ff205f77/1de891217d94f99139e136672e00b906/dotnet-runtime-2.1.20-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/653748ee-42bb-46f0-b6b8-5894c3a831d5/88894226cb03fe2fcd939ee75a384b44/dotnet-runtime-2.1.20-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3b7f548-4cb0-43f6-be68-7a7ac3855d17/a70d2570eac5e2dd8ca57b702336074e/dotnet-runtime-2.1.20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/38d699f3-3ceb-4952-afb5-7b770cb60af1/bd49857a8755cf5d30274425f3f1623b/dotnet-runtime-2.1.20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a29a360-61df-4c06-af5b-c43c4da3ba0a/eb1e0c23ffc95d5f9d9b2aa0c103d034/dotnet-runtime-2.1.20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7545c5ac-694e-49d6-a4b2-aaf4c0287c60/6c2c622c1156f40f05f31d1e1bed387b/dotnet-runtime-2.1.20-win-x86.zip

[//]: # ( ASP 2.1.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/292e38b1-bab5-4b15-8659-dfe8e3d6841b/2ca074694939aa06709070ffa91fad53/aspnetcore-runtime-2.1.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/123cd951-e45d-477c-a4f2-c4fc4b8875f7/701f625ad38b7b3a4ffe5f400d528e0f/aspnetcore-runtime-2.1.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f71a9aa8-b3f4-4afd-8200-3baf39a88b6b/4f91b8b5df2117ba35acf008c88f89e3/aspnetcore-runtime-2.1.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce092775-e76f-44de-b166-24d5fb309d1c/44da312c8749621cf6d087c8279606bc/aspnetcore-runtime-2.1.20-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dc9d0c4f-9826-43ff-ac08-ca40733ad372/36de3302a2d6c6cdebea8b7bf564c1b2/aspnetcore-runtime-2.1.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/302ed10c-e687-469c-a544-7e07b264caad/93b1e8e57f8e3f7d8ba360235a317700/aspnetcore-runtime-2.1.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2b4ee6af-f5c8-4901-bbca-50b8c3364d20/5a4860645c0efdba4ca6a6400dcbd525/aspnetcore-runtime-2.1.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0e437534-aab8-4f83-95fb-dd4e8275f5aa/e13004c1dc090c0bc4d4715766cf9bed/aspnetcore-runtime-2.1.20-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/fa2c9d72-dda4-4b9c-ae58-97d4f36dbd63/fb2dfa6b0fede5d060ee3bae9d4223f5/dotnet-hosting-2.1.20-win.exe


[//]: # ( SDK 2.1.613 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6a4d53f-9efa-4467-8dc2-819679b78d17/a0fb69b42251961276a2eaa4a187c3fc/dotnet-sdk-2.1.613-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89b401bc-a0b1-42d2-92d5-a42554396ef5/5b64b87e1945c452fdd8df8356bd5d54/dotnet-sdk-2.1.613-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c498724-a719-4524-9338-59ce00b8079a/ce615cbd3884ce8deb90c87e6357adce/dotnet-sdk-2.1.613-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6101639-e4b8-4602-80b8-6eba14b06336/9853acd7fbcd7e862d2c1daa9987ec2a/dotnet-sdk-2.1.613-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/43ebc180-0ea1-404f-83b2-23c19582e230/49573e63960afe6540436add7725968a/dotnet-sdk-2.1.613-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4c3dcb8-daea-4e20-902f-a8e254aead74/0332bde0ef7a0875f16523c5675cb4ba/dotnet-sdk-2.1.613-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbedfb51-b4ed-40f1-b993-33adc50ae4ab/96b4011ea516306a95f3891ac10dde17/dotnet-sdk-2.1.613-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/79e3b0b6-c702-42ad-b80a-62d7a28df97e/fbc9dadf3088a3b0825decf328b8f403/dotnet-sdk-2.1.613-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6c75b6df-ff33-4e1a-9425-a0d7b8b0c3f0/2a58c4a9c39ce9c4d650f651f1368a37/dotnet-sdk-2.1.613-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/53d95e92-756f-4e97-a500-a06972970998/b0fc9ad24909cf449659a9aeb7e4f87a/dotnet-sdk-2.1.613-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5629ceba-a3a5-45f6-8973-9aca0d5cceb2/56a8284859787878ba99af693cfb8f71/dotnet-sdk-2.1.613-win-x86.zip


[//]: # ( Symbols )