# .NET Core 2.1.614

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.614
* .NET Core Runtime 2.1.21
* ASP.NET Core 2.1.21

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.21/2.1.21.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.614](#downloads) |
| Windows | Visual Studio 2017 | [2.1.517](2.1.21.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.21-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.21/2.1.21.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.21-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.21-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/


[//]: # ( Runtime 2.1.21)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d9e3a34-c4bc-4927-91e5-3162cad6070d/30dd5443a1248ada23c69b92cd11cfb3/dotnet-runtime-2.1.21-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5913eed-2f38-486a-b5ec-4d71823d094c/37d35e05b1012f867820c3b1f3aa267f/dotnet-runtime-2.1.21-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbad6717-093a-451d-a029-40ed859f5446/05e1679eb3a289db254ec7ba26a2b0e1/dotnet-runtime-2.1.21-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76cf51d4-8407-46a9-9ba0-c44b8c62b553/8af610974c8636cd4e7b7ec0f17ac32a/dotnet-runtime-2.1.21-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fbf39021-7b6d-4f7f-9c28-a3dbbee54d78/11f078f6216b5cfce2d266d1d69ea6a0/dotnet-runtime-2.1.21-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b662c01-32c5-46f6-85bf-af3d17db7cd3/7ed886e7dcba82c56aba7e201ea94acd/dotnet-runtime-2.1.21-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4bb4768-6e16-49ae-85a8-0de15034e448/a60d2e6337baa4a57310b916bd2db78a/dotnet-runtime-2.1.21-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/53b1ba7a-cc66-4656-ac91-f7bef7a82fda/0c5505bf0fbbbbd2f530cb27abb10795/dotnet-runtime-2.1.21-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4fae061c-6d91-4064-9730-390e9e320e85/11b473780ff9ec355fd3aab050e53673/dotnet-runtime-2.1.21-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6da71f8c-dbcb-4b16-b613-bf41186ac6fb/85ea08b921bc9ec67f072ff8685a7ccc/dotnet-runtime-2.1.21-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e8e9f678-b48c-47b7-90d6-a7082941ecb3/b8aa5fe497c44b934fa24415187d30a0/dotnet-runtime-2.1.21-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bde5bd01-922b-42f0-abd0-2c680f054725/c31a9999f79c8e1f9bb3ff1f23d064cc/dotnet-runtime-2.1.21-win-x86.zip

[//]: # ( ASP 2.1.21)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/046ab9e4-87de-4b98-ab0a-fd42fc635636/fa07410e118e6fb39b93cc53d099b801/aspnetcore-runtime-2.1.21-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64266476-0bda-4306-8951-1e881d4fac1f/a71cce07158008e879bd407424b49f55/aspnetcore-runtime-2.1.21-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d6ae2ec-4cf8-4579-bdfb-18c723b1a560/48be79a406578690a3f062ff17d663f8/aspnetcore-runtime-2.1.21-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f7b66f9-3867-4495-89bf-ba018071c49d/8d9598344fb90a4ef2737f2276a8fc87/aspnetcore-runtime-2.1.21-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/85cc46f2-8674-4429-85a5-1304ec22a15d/d30356ec081792b178539c07d7a974f9/aspnetcore-runtime-2.1.21-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2fa05cff-91bf-42a0-842e-54859202d23e/655ba086a521e40fc61d955f7ee85e06/aspnetcore-runtime-2.1.21-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ee261cd9-b4b6-4db3-ab22-851dec8626ff/39f3e34e5b342f56cf147d5690e87732/aspnetcore-runtime-2.1.21-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3598415f-5c12-4da7-8a05-9acde58a9c0e/d19cf25598304e4fe6d5676c7f2b7b90/aspnetcore-runtime-2.1.21-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ddde4319-0780-4b63-95e0-6dffc6445475/8545d6638e0b94440ed56f57f5a15410/dotnet-hosting-2.1.21-win.exe


[//]: # ( SDK 2.1.614 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1e297d1-26ae-4956-aafa-6cb9088606d7/f63e5db74cf26f1db1937fb2c01e91bb/dotnet-sdk-2.1.614-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ac3d54b-dece-496e-9e29-4254ce95efdf/cfb3db0534e0552f2c12eb4f9b528a3e/dotnet-sdk-2.1.614-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3bbefb8-510b-4e95-adfe-b72c8b5c4997/77466747d8b44bab2e2af7bab9e78d53/dotnet-sdk-2.1.614-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1d1f6c1-7c99-47cf-a358-08c4170e9553/3e5ecd30ad8e60a0de7d377b8f5249e9/dotnet-sdk-2.1.614-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5053ca77-b571-45f4-b5ed-b00fde2853ae/fc5c67d23ca76c96a3dccf9b46f162f5/dotnet-sdk-2.1.614-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1cdeeeab-6913-4598-9558-e7e88a9dbab2/f6611e83fa7aabe2d09c0341d6466026/dotnet-sdk-2.1.614-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30e39901-936b-4321-937e-bf26521c13b8/cee04649a395b559aed4a2e5d1447af5/dotnet-sdk-2.1.614-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1a67aa02-c452-46b2-af95-337d5dfce66c/4ae55ec0500c8b12c6e69ea50dcb66cd/dotnet-sdk-2.1.614-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/db0a8f1f-335b-4767-9086-09b34fd904b8/7971ef7dcfb541889fd77e841da4f23e/dotnet-sdk-2.1.614-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/442f4184-3e88-419d-b4e6-1be11e4ebb69/d9d0bf9d027d1089c5481ab6c6e287e6/dotnet-sdk-2.1.614-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fa6c7e1d-cf14-4b60-8b84-10b91ce23378/9573d41a3342b067d21d97ca18f43eb3/dotnet-sdk-2.1.614-win-x86.zip

