# .NET Core August 2018 Update - August 21, 2018

.NET Core 2.1.3 is available for [download](2.1.3-download.md) and usage in your environment. This release includes .NET Core 2.1.3, ASP.NET Core 2.1.3 and .NET Core SDK 2.1.401.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-213)
* [Known Issues](../2.1-known-issues.md)
* [Lifecycle](#net-core-lifecycle-news)

Visit the [.NET Core blog][dotnet-blog] to read more about this release. Your feedback is important and appreciated. We've created an issue at [dotnet/core #1875](https://github.com/dotnet/core/issues/1875) for your questions and comments.

## Downloads

|           | SDK Installer*                                   | SDK Binaries*                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br> [Hosting Bundle][hosting-win-x64.exe] |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]
| Linux     | [See installations steps below][linux-install]   | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm-x32] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm-x32] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]  \| [ARM32][asp-runtime-linux-arm-x86] \| [x64 Alpine][asp-runtime-linux-musl-x64] |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][symbols-coreclr] \| [Shared Framework][symbols-corefx] \| [Setup][symbols-core-setup] | - | [ASP.NET Core][symbols-aspnetcore] |

\* Includes the .NET Core and ASP.NET Core runtimes

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* Deployment of .NET Core 2.1.3 to Azure App Services has been delayed and is expected to take place the week of August 27.

## .NET Core Lifecycle News

### 2.1.3 declared LTS

With the August Update, we are pleased to announce that 2.1.3 begins the .NET Core 2.1 LTS lifecycle. We will continue to update 2.1 with important fixes to address security and reliability issues as wells as add support for new operating system versions. Details on the .NET Core lifecycle can be seen in the [.NET Core support policy](https://dotnet.microsoft.com/platform/support/policy/).

The LTS designation covers all packages referenced by `Microsoft.NETCore.App` and `Microsoft.AspNetCore.App`. To ensure that applications which are chosen to run on 2.1 remain on the LTS supported updates, it's important to reference these packages rather than 'loose' packages. This will enable the applications to properly utilize .NET Core 2.1 updates when they are released and installed.

The .NET Core SDK is not included as part of the LTS designation. SDK fixes will continue to be released in the latest version 'train' which supports maintaining and building applications for .NET Core 2.1.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

### Supported Linux version changes

No changes in support for August. Support for OpenSUSE 15 and SLES 15 will be coming in a future 2.1 update.

## Notable Changes in 2.1.3

We have fixed a number of important reliability and functional issues for 2.1.3. Included in these fixes is compatibility work for the macOS Mojave updated, expected sometime in September. If you are a running Mojave beta, let us know if there are any issues running .NET Core after this update.

All fixes of note can be seen in the [2.1.3 commits](2.1.3-commits.md) list.

Please see the [ASP.NET Core release notes](https://github.com/aspnet/Home/releases/tag/2.1.3) for highlights and known issues on work from ASP.NET Core, MVC, Entity Framework Core and others.

[dlc-runtime]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C
[dlc-sdk]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.3.md

[runtime-linux-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-linux-x64.tar.gz
[runtime-linux-arm-x32]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-linux-arm64.tar.gz
[runtime-rhel.6-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-rhel.6-x64.tar.gz
[runtime-mac-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-osx-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-osx-x64.pkg
[runtime-win-x86]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-win-x86.zip
[runtime-win-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-win-x64.zip
[runtime-win-x86.exe]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-win-x86.exe
[runtime-win-x64.exe]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-runtime-2.1.3-win-x64.exe

[sdk-linux-x64]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-linux-x64.tar.gz
[sdk-linux-arm-x32]:  https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-linux-arm.tar.gz
[sdk-linux-arm-x64]:  https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-linux-arm64.tar.gz
[sdk-linux-musl-x64]:  https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-linux-musl-x64.tar.gz
[sdk-mac-x64]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-osx-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-osx-x64.pkg
[sdk-mac-x64.pkg-gs]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-osx-gs-x64.pkg
[sdk-win-x86]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-x86.zip
[sdk-win-x64]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-x64.zip
[sdk-win-x86.exe]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-x86.exe
[sdk-win-x86.exe-gs]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-gs-x86.exe
[sdk-win-x64.exe]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-x64.exe
[sdk-win-x64.exe-gs]: https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-win-gs-x64.exe
[sdk-rhel.6-x64]:  https://download.microsoft.com/download/E/8/A/E8AF2EE0-5DDA-4420-A395-D1A50EEFD83E/dotnet-sdk-2.1.401-rhel.6-x64.tar.gz

[hosting-win-x64.exe]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/dotnet-hosting-2.1.3-win.exe
[asp-runtime-linux-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-linux-x64.tar.gz
[asp-runtime-linux-arm-x86]:  https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-linux-musl-x64.tar.gz
[asp-runtime-mac-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-win-x64.exe
[asp-runtime-win-x86.exe]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-win-x86.exe
[asp-runtime-win-x86]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-win-x86.zip
[asp-runtime-win-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-runtime-2.1.3-win-x64.zip
[asp-store-linux-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-store-2.1.3-linux-x64.tar.gz
[asp-store-mac-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnetcore-store-2.1.3-osx-x64.tar.gz
[asp-store-win-x64]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/AspNetCore.2.1.3.RuntimePackageStore_x64.exe
[asp-store-win-x86]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/AspNetCore.2.1.3.RuntimePackageStore_x86.exe

[symbols-aspnetcore]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/aspnet-2.1.3-symbols.zip
[symbols-coreclr]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/coreclr-2.1.3-symbols.zip
[symbols-corefx]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/corefx-2.1.3-symbols.zip
[symbols-core-setup]: https://download.microsoft.com/download/6/E/B/6EBD972D-2E2F-41EB-9668-F73F5FDDC09C/core-setup-2.1.3-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.3-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.401-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2018/08/21/net-core-august-2018-update/
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md
