# .NET Core 2.2.0 - December 04, 2018

.NET Core 2.2.0 is available for download and usage in your environment. This release includes .NET Core 2.2.0 and .NET Core SDK 2.2.100. Have a look at the [Known Issues](../2.2-known-issues.md) document as there are a few things to be aware of before installing. All fixes of note can be seen in the [.NET Core 2.2.0 commits](2.2.0-commits.md) list.

* [Downloads](#downloads)

## Blog Round up

* [.NET Core][dotnet-blog]
* [ASP.NET Core](https://aka.ms/aspnetcore22announce)
* [Entity Framework Core](https://aka.ms/efcore22announce)

The ASP.NET Core side of the team has been hard at work for this release so give the [ASP.NET](https://aka.ms/aspnetcore22announce) and [EF](https://aka.ms/efcore22announce) blogs extra attention to learn more about the new features and enhancements.

The .NET Core SDK 2.2.100 includes .NET Core 2.2 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.2.100, the following command will show that you're running version `2.2.100` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2098](https://github.com/dotnet/core/issues/2098) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repo has been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)

## Azure AppServices

* Deployment of .NET Core 2.2.0 to Azure App Services is complete. ANCM (ASP.NET Core Module) deployment is delayed and is expected to complete later in December. 

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.2/2.2.0/2.2.0.md

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/860e937d-aa99-4047-b957-63b4cba047de/da5ed8a5e7c1ac3b4f3d59469789adac/aspnetcore-runtime-2.2.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60655cf9-5d19-4146-ac65-7ce8a23b5a4b/4393f9d9c5ebe85a2e27d83f500a6562/aspnetcore-runtime-2.2.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69ee3993-54fe-4687-9388-25b1e0c888fb/df2ba0637e68f6e8ee212a38756a4002/aspnetcore-runtime-2.2.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/569b6c23-1b22-458f-91d0-b7b45ad4efcd/daafc07506cf1e42d62b6df0c1843515/aspnetcore-runtime-2.2.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7f19b834-339a-41b2-8709-0f29dcb27ce8/e062f2bc065c89ae80d3f5a118534664/aspnetcore-runtime-2.2.0-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4d87102c-31b3-46a0-bf94-698a12481366/a1c3cdf6cc5a5029b58329954430129b/aspnetcore-runtime-2.2.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8073bb2c-6e05-4486-81eb-f37cb714a1b6/03ffd5e3934f6143cdfc87e04ccc3797/aspnetcore-runtime-2.2.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/70800ed3-22cd-4111-9e00-e9fc3535d5c6/f7b76341e582f3a8952b7fdec06e0646/aspnetcore-runtime-2.2.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3974a408-f437-44e7-8bf2-8ccf7f6ef73e/bcc8807e64d3b24c8cfd43e9f47521e5/aspnetcore-runtime-2.2.0-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/48adfc75-bce7-4621-ae7a-5f3c4cf4fc1f/9a8e07173697581a6ada4bf04c845a05/dotnet-hosting-2.2.0-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3f3e38e-246a-4eab-8da3-63f9cd1b1c13/c2e795a9bb03bc75d3cfa767f3f77310/dotnet-runtime-2.2.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8931cb99-76f8-4d62-82be-881b79b03aac/9b31f0cbd0caac6d1639cece76d414a8/dotnet-runtime-2.2.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bb6c059-a9fe-44ad-9f9e-12027c858253/2742ebd7660077902e4a5f3f85d156c7/dotnet-runtime-2.2.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1057e14e-16cc-410b-80a4-5c2420c8359c/004dc3ce8255475d4723de9a011ac513/dotnet-runtime-2.2.0-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/953c69dc-2b70-4237-89e8-d0675d8e89b7/4ccde130c14f69659da5826c0b2fbe95/dotnet-runtime-2.2.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d8682c5-f211-4724-9f6b-0d44eb1593d4/32d8ff5607122a05e2200fe0961cfc40/dotnet-runtime-2.2.0-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/279664c2-a29a-423b-967d-d58bc7abe14c/a40e0f1065c062b6dc91cf4523111513/dotnet-runtime-2.2.0-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/42443f24-e035-42c2-a998-57f58a7573ea/d885e17a85793394ad12b804999cfc32/dotnet-runtime-2.2.0-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/be1aa948-6b3a-418c-bb85-5bb8ca4be04c/8aa70e41272cbaf2b619b4cd4824974b/dotnet-runtime-2.2.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/03b9322b-c24d-4219-a092-baf7d6e4d124/83a706f62a41c466805dedc23429427b/dotnet-runtime-2.2.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62711024-fa98-4919-9fe0-466744b20941/4cdef0431350a441b45e11784f657b09/dotnet-runtime-2.2.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2ed3aa9d-dd33-4a00-bb51-814de2b92d0c/0624fc37ff340d2b38c95a1f667de99c/dotnet-runtime-2.2.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ab4bbec2-ace5-487b-85fd-4ac897440040/23e50fbfc65d3b54aec21107eeb0a66d/dotnet-runtime-2.2.0-win-x86.zip
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35c09285-4114-44f7-aa7d-47fe75a55eda/ac5a8f1bc324f2a6cd021237528441d4/dotnet-sdk-2.2.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d17344d-0244-4c49-94dd-5502eae2df90/e9ef3fc189d210dac9d8ffac97a7a51e/dotnet-sdk-2.2.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fc70c4d-52a4-48b3-85c7-43af96c397c8/1548af0c8f4f7b8b5dc5a187af463a03/dotnet-sdk-2.2.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/519eac6e-f2c9-49dd-a60d-02072ed8e5b3/aed96c5eee6a74a5cde2e3f1ad4c7121/dotnet-sdk-2.2.100-linux-x64.tar.gz
[dotnet-sdk-osx-gs-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4524456c-d9b7-46b3-99a2-7a4b21a26fb7/1fe6edb9e60ddd1b5f79381e9d0a3738/dotnet-sdk-2.2.100-osx-gs-x64.pkg
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/29457b8f-6262-4c4b-8a54-eef308346842/3c7ec575796a2ef0e826a07ca4d13084/dotnet-sdk-2.2.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3100b00b-4e63-4d49-bd59-297931016032/b71d2aff0d650b5501258a54b0cd2ea7/dotnet-sdk-2.2.100-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd3cfd65-9129-4f00-896f-26bd3db5e71e/e42d8580114129bbf1225b19a72086c9/dotnet-sdk-2.2.100-rhel.6-x64.tar.gz
[dotnet-sdk-win-gs-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ecde9720-0283-4869-897e-93467ba8cd45/d90fa7f9ed6149f76b0d5cd30ac35676/dotnet-sdk-2.2.100-win-gs-x64.exe
[dotnet-sdk-win-gs-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6dc0eaf5-1ed2-49a9-adfa-8112d3a551f0/7bb64b14cf8e67d6c9b90881c1af3ef4/dotnet-sdk-2.2.100-win-gs-x86.exe
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7ae62589-2bc1-412d-a653-5336cff54194/b573c4b135280fb369e671a8f477163a/dotnet-sdk-2.2.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02a78e5a-3e7b-4d7e-a730-b46c9f551346/6dae57a34f649095d745acedb773d75f/dotnet-sdk-2.2.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c7aecc9d-e8d0-451b-a5ed-de3095459883/9fcfdce401be67e0e53eee337e6c82c4/dotnet-sdk-2.2.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/84beb25f-e3ad-4fde-b90d-907d499d3dfc/2cadffd93faaf3c6e5b9b8f8c1767180/dotnet-sdk-2.2.100-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e0c8c95e-4e4c-4cc3-9b5c-7c6740feba1f/3cae4aeb08ededcc4b6d0986eee3fb80/aspnet-2.2.0-symbols.zip
[aspnet-extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/81c09839-3d1f-42d8-8a14-a52cba70c8a4/04280557d2b96f0840cbf4c4ea59937c/aspnet-extensions-2.2.0-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/546ad62a-4839-4170-9a59-86c569f18725/69bd4fe0372becfb354264f664b12d5b/cli-2.2.0-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/53b39749-d31a-4272-a280-8d3cd1974922/da1c0fb161ecdc0c09810b98bb115ffb/core-setup-2.2.0-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/a6a3fcc6-e72c-4d56-a002-c1ea2ebf491b/b00ec1d7aeee16b002579e7855d8574a/coreclr-2.2.0-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6576cf85-ad10-49c7-ab3f-f26c2ba1e518/621fc14558560a3c585697ee5e77993a/corefx-2.2.0-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4b233b85-7b9b-4e7b-a2ed-62fd6017b65e/91ed01dbe66f087e9d7b5f0a7c97f289/dotnet-sdk-2.2.0-symbols.zip
[sdk-symbols-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b14fc6a3-2fe4-4cb5-8083-d752ca106944/86f2e153b184b09ef90ac4499cec0ef6/sdk-symbols-2.2.0-symbols.zip
[templating-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/52249021-0c7f-477a-b961-72b64694fb47/22b0006ce020a668309a2c254f2996f4/templating-2.2.0-symbols.zip
[websdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0ecfbde4-d827-4e2a-b2ae-b67f1e72495b/8a5e533a4b846d6877be4420a42664fd/websdk-2.2.0-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.0-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.100-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://aka.ms/netcore22announce
