# .NET Core SDK 2.2.301

This .NET Core SDK release is the version which shipped with Visual Studio 2019. It includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.2.301
* .NET Core Runtime 2.2.6
* ASP.NET Core 2.2.6

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.2/2.2.6/2.2.6.md) for details about what is included in this update.

**NOTE:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 (Windows) | [2.2.108](../2.2.6/2.2.6-download.md) |
| Visual Studio 2019 version 16.0 (Windows) | [2.2.205](2.2.205-sdk-download.md) |
| Visual Studio 2019 version 16.1 (Windows) | [2.2.301](#downloads) |
| Visual Studio 2019 version 16.2 (Windows) | [2.2.401](2.2.401-sdk-download.md) |
| Visual Studio for Mac | https://docs.microsoft.com/visualstudio/mac/net-core-support |

## Downloads
|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli223xx-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.2
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.2
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.2` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.2` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.2.6-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.2/2.2.6/2.2.6.md

[//]: # ( Runtime 2.2.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/428aaa32-f66c-4847-b845-aa21f90504e4/1cf033db866414997140c2672bd75069/dotnet-runtime-2.2.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5e04830-50fc-435c-8bb5-fcd4629da944/8aa7cce5c3fcb6a7db180b923d3574ef/dotnet-runtime-2.2.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6b8ba2c-30f2-4bb8-80ed-3f12ac623c41/2455fd6f2369d9a7396bb363482e9047/dotnet-runtime-2.2.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f21e352-9d2c-4e3b-af45-915da89158db/0e8a7ea83cc08d4bcf417a927a36ed6f/dotnet-runtime-2.2.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7fd8704c-560f-47dc-8fe0-b777e5e743e7/d7a4476f50828bf4095455b49c02cc01/dotnet-runtime-2.2.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c986070-0a73-4414-9067-61181fc0895a/7320179081b9d38d9acaae68a22c51a2/dotnet-runtime-2.2.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26800e2a-e889-4cef-a48e-5e9cf98fcd6a/b3103fe551ed2d81a56e4fe057d1a230/dotnet-runtime-2.2.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/fcb51bad-4ce4-4bec-bd82-845d404f2740/7ff61be20c8038a966a62b8ce76b06d4/dotnet-runtime-2.2.6-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e65be1d4-dbe3-460c-8517-3fafb26b3dc4/e7760a9dbb9135e3b0b0150f36ef0f05/dotnet-runtime-2.2.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/215c9079-af62-4265-aea5-1ee400b475ae/0c718d5c8fff0926c9eeec76221de22c/dotnet-runtime-2.2.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f9b622df-fc7d-4ec6-8996-b03ad7553c93/910152992719bfee5011c722ae82c680/dotnet-runtime-2.2.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/69872dbc-3e5d-42e9-bb1a-ae72c98c8392/8c6fa5f8a539ff93009ea81533c1d69b/dotnet-runtime-2.2.6-win-x86.zip

[//]: # ( ASP 2.2.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13798f38-c14e-4944-83c9-4f5b7c535f4d/1e1c3414f3ad791098d1f654640f9bcf/aspnetcore-runtime-2.2.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3257647-9887-4822-8a18-0debbeabd3b2/5cd0346e78464231883604e544cee8dd/aspnetcore-runtime-2.2.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d59077f-07f3-4997-b514-d88bce8cdcbf/3729ac370c4b96720829e098bee7ee5e/aspnetcore-runtime-2.2.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65bfd3c1-8321-4496-97d7-cad0743e2aea/7a23c05f5842df826017e4c8d3482d47/aspnetcore-runtime-2.2.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8ded9840-cde7-44ed-aa96-76135d7d7945/7bc757c65f531dc997379b7dd9066c8e/aspnetcore-runtime-2.2.6-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a021d9b2-8585-473c-a8d1-011717383ad7/819dbf76040767ed1a49d6c7c5681b8a/aspnetcore-runtime-2.2.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/add4620e-7d1f-4e04-bff2-361fa1e19347/20e8bceb10fe70eb8a5255b1bed9d80d/aspnetcore-runtime-2.2.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f67e7c14-7be8-48be-a58f-6fcbb1e40e8f/5ef54f876d48a645b1015e76b97cf75b/aspnetcore-runtime-2.2.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/396c5a1d-352a-42b5-8819-8939565982a5/d71358582d46baafb6abc1b57e350632/aspnetcore-runtime-2.2.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a9bb6d52-5f3f-4f95-90c2-084c499e4e33/eba3019b555bb9327079a0b1142cc5b2/dotnet-hosting-2.2.6-win.exe

[//]: # ( SDK 2.2.301 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bc4d8e7-e736-4323-b82c-f75559502e9c/582e01f7b7a67cd23a22e5bfff317f10/dotnet-sdk-2.2.301-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0af74ee1-47bb-43bd-b55f-1657f079c309/6649fd1bc91b14aee4a6b4ed44a2f45d/dotnet-sdk-2.2.301-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9bf52b85-f9fa-417e-9f3c-a3a83fcc6d46/ebff0554910172dbde7484035f0fdc73/dotnet-sdk-2.2.301-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3224f4c4-8333-4b78-b357-144f7d575ce5/ce8cb4b466bba08d7554fe0900ddc9dd/dotnet-sdk-2.2.301-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1440e4a9-4e5f-4148-b8d2-8a2b3da4e622/d0c5cb2712e51c188200ea420d771c2f/dotnet-sdk-2.2.301-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/838546de-7f3d-4fc9-98ef-fff8c8e45e17/c09e44c880ec45c0a202f59a943a13eb/dotnet-sdk-2.2.301-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a04bea27-1d6d-49fb-a76d-cfd3876001c3/a9b98db9d439d37378e999a9351621e3/dotnet-sdk-2.2.301-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/221613f8-831f-4fe1-b296-f45cc3f99aa0/f41c279b9317b6e72bfb2dbbf4053b0f/dotnet-sdk-2.2.301-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/15e45d59-071a-448f-9ebe-361fa8d7b55c/e028b3bc38bb96e982cfab90003683dc/dotnet-sdk-2.2.301-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c7fcb0b-52ee-40b2-853d-710c58883371/78bbdf5fcd85697e8e306c355d02d0b0/dotnet-sdk-2.2.301-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ffea64d6-9050-406a-a9a7-00abcbbac35d/d3f943d449982b552cc35ed279e24edb/dotnet-sdk-2.2.301-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/20a278a3-0a11-4cea-bf4b-6444f39d2439/86cdf5de22d23321b76be7ee238fe154/dotnet-sdk-2.2.301-win-x86.zip

[//]: # ( Symbols )
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f9fccf37-ce4b-414c-a4cd-11ecc8610335/e41ec68f6402d011dc6ae246736537b7/aspnet-2.2.6-symbols.zip
[cli221xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0bd795f2-f80b-4720-a696-6362647557bb/96cefd20ffd9ccd334987d6e8cd0b802/cli221xx-2.2.6-symbols.zip
[cli222xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/975d33ef-a61a-4ca2-8e86-b0e2e4426e7e/998d6fa933b991fb59a716388b7b33c0/cli222xx-2.2.6-symbols.zip
[cli223xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/127909c4-cfae-4927-9f6f-a5e276a8c2e4/fc7d215a493d14c517f1e675064933b9/cli223xx-2.2.6-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/df2e74d6-c3d6-4146-b92c-07b017db7c47/d85c2c17949a80c38166f199451b4d1e/core-setup-2.2.6-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ac44b040-59a7-4c31-b1f3-d307666533c0/928e45c40fc96d65d6b0208add08919a/coreclr-2.2.6-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/a11480e5-d099-4351-91ca-f8fd50f1f5df/bfc5bd03d27d857d98846c31dc6625d4/corefx-2.2.6-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d64002d7-fcc2-4d47-a903-28ab7904dfec/c7e49df6e74debd1c386ef226239dfdc/dotnet-sdk-2.2.6-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.6-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.301-sdk-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/
