# Microsoft.AspNetCore.Authentication.Negotiate

``` diff
 {
+    namespace Microsoft.AspNetCore.Authentication.Negotiate {
+        public class AuthenticatedContext : ResultContext<NegotiateOptions> {
+            public AuthenticatedContext(HttpContext context, AuthenticationScheme scheme, NegotiateOptions options);
+        }
+        public class AuthenticationFailedContext : RemoteAuthenticationContext<NegotiateOptions> {
+            public AuthenticationFailedContext(HttpContext context, AuthenticationScheme scheme, NegotiateOptions options);
+            public Exception Exception { get; set; }
+        }
+        public class ChallengeContext : PropertiesContext<NegotiateOptions> {
+            public ChallengeContext(HttpContext context, AuthenticationScheme scheme, NegotiateOptions options, AuthenticationProperties properties);
+            public bool Handled { get; private set; }
+            public void HandleResponse();
+        }
+        public static class NegotiateDefaults {
+            public const string AuthenticationScheme = "Negotiate";
+        }
+        public class NegotiateEvents {
+            public NegotiateEvents();
+            public Func<AuthenticatedContext, Task> OnAuthenticated { get; set; }
+            public Func<AuthenticationFailedContext, Task> OnAuthenticationFailed { get; set; }
+            public Func<ChallengeContext, Task> OnChallenge { get; set; }
+            public virtual Task Authenticated(AuthenticatedContext context);
+            public virtual Task AuthenticationFailed(AuthenticationFailedContext context);
+            public virtual Task Challenge(ChallengeContext context);
+        }
+        public class NegotiateHandler : AuthenticationHandler<NegotiateOptions>, IAuthenticationHandler, IAuthenticationRequestHandler {
+            public NegotiateHandler(IOptionsMonitor<NegotiateOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+            protected new NegotiateEvents Events { get; set; }
+            protected override Task<object> CreateEventsAsync();
+            protected override Task<AuthenticateResult> HandleAuthenticateAsync();
+            protected override Task HandleChallengeAsync(AuthenticationProperties properties);
+            public Task<bool> HandleRequestAsync();
+        }
+        public class NegotiateOptions : AuthenticationSchemeOptions {
+            public NegotiateOptions();
+            public new NegotiateEvents Events { get; set; }
+            public bool PersistKerberosCredentials { get; set; }
+            public bool PersistNtlmCredentials { get; set; }
+        }
+        public class PostConfigureNegotiateOptions : IPostConfigureOptions<NegotiateOptions> {
+            public PostConfigureNegotiateOptions(IEnumerable<IServerIntegratedAuth> serverAuthServices, ILogger<NegotiateHandler> logger);
+            public void PostConfigure(string name, NegotiateOptions options);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class NegotiateExtensions {
+            public static AuthenticationBuilder AddNegotiate(this AuthenticationBuilder builder);
+            public static AuthenticationBuilder AddNegotiate(this AuthenticationBuilder builder, Action<NegotiateOptions> configureOptions);
+            public static AuthenticationBuilder AddNegotiate(this AuthenticationBuilder builder, string authenticationScheme, Action<NegotiateOptions> configureOptions);
+            public static AuthenticationBuilder AddNegotiate(this AuthenticationBuilder builder, string authenticationScheme, string displayName, Action<NegotiateOptions> configureOptions);
+        }
+    }
+}
```

