# Microsoft.AspNetCore.Authentication.OAuth

``` diff
 {
     namespace Microsoft.AspNetCore.Authentication {
         public static class ClaimActionCollectionMapExtensions {
-            public static void MapCustomJson(this ClaimActionCollection collection, string claimType, Func<JObject, string> resolver);

+            public static void MapCustomJson(this ClaimActionCollection collection, string claimType, Func<JsonElement, string> resolver);
-            public static void MapCustomJson(this ClaimActionCollection collection, string claimType, string valueType, Func<JObject, string> resolver);

+            public static void MapCustomJson(this ClaimActionCollection collection, string claimType, string valueType, Func<JsonElement, string> resolver);
         }
     }
     namespace Microsoft.AspNetCore.Authentication.OAuth {
+        public class OAuthCodeExchangeContext {
+            public OAuthCodeExchangeContext(AuthenticationProperties properties, string code, string redirectUri);
+            public string Code { get; }
+            public AuthenticationProperties Properties { get; }
+            public string RedirectUri { get; }
+        }
+        public static class OAuthConstants {
+            public static readonly string CodeChallengeKey;
+            public static readonly string CodeChallengeMethodKey;
+            public static readonly string CodeChallengeMethodS256;
+            public static readonly string CodeVerifierKey;
+        }
         public class OAuthCreatingTicketContext : ResultContext<OAuthOptions> {
-            public OAuthCreatingTicketContext(ClaimsPrincipal principal, AuthenticationProperties properties, HttpContext context, AuthenticationScheme scheme, OAuthOptions options, HttpClient backchannel, OAuthTokenResponse tokens);

-            public OAuthCreatingTicketContext(ClaimsPrincipal principal, AuthenticationProperties properties, HttpContext context, AuthenticationScheme scheme, OAuthOptions options, HttpClient backchannel, OAuthTokenResponse tokens, JObject user);

+            public OAuthCreatingTicketContext(ClaimsPrincipal principal, AuthenticationProperties properties, HttpContext context, AuthenticationScheme scheme, OAuthOptions options, HttpClient backchannel, OAuthTokenResponse tokens, JsonElement user);
-            public JObject User { get; }
+            public JsonElement User { get; }
-            public void RunClaimActions(JObject userData);

+            public void RunClaimActions(JsonElement userData);
         }
         public class OAuthHandler<TOptions> : RemoteAuthenticationHandler<TOptions> where TOptions : OAuthOptions, new() {
+            protected virtual Task<OAuthTokenResponse> ExchangeCodeAsync(OAuthCodeExchangeContext context);
-            protected virtual Task<OAuthTokenResponse> ExchangeCodeAsync(string code, string redirectUri);

         }
         public class OAuthOptions : RemoteAuthenticationOptions {
+            public bool UsePkce { get; set; }
         }
-        public class OAuthTokenResponse {
+        public class OAuthTokenResponse : IDisposable {
-            public JObject Response { get; set; }
+            public JsonDocument Response { get; set; }
+            public void Dispose();
-            public static OAuthTokenResponse Success(JObject response);

+            public static OAuthTokenResponse Success(JsonDocument response);
         }
     }
     namespace Microsoft.AspNetCore.Authentication.OAuth.Claims {
         public abstract class ClaimAction {
-            public abstract void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public abstract void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
         public class CustomJsonClaimAction : ClaimAction {
-            public CustomJsonClaimAction(string claimType, string valueType, Func<JObject, string> resolver);

+            public CustomJsonClaimAction(string claimType, string valueType, Func<JsonElement, string> resolver);
-            public Func<JObject, string> Resolver { get; }
+            public Func<JsonElement, string> Resolver { get; }
-            public override void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public override void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
         public class DeleteClaimAction : ClaimAction {
-            public override void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public override void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
         public class JsonKeyClaimAction : ClaimAction {
-            public override void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public override void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
         public class JsonSubKeyClaimAction : JsonKeyClaimAction {
-            public override void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public override void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
         public class MapAllClaimsAction : ClaimAction {
-            public override void Run(JObject userData, ClaimsIdentity identity, string issuer);

+            public override void Run(JsonElement userData, ClaimsIdentity identity, string issuer);
         }
     }
-    namespace Microsoft.AspNetCore.Builder {
 {
-        public static class OAuthAppBuilderExtensions {
 {
-            public static IApplicationBuilder UseOAuthAuthentication(this IApplicationBuilder app);

-            public static IApplicationBuilder UseOAuthAuthentication(this IApplicationBuilder app, OAuthOptions options);

-        }
-    }
 }
```

