# System.IO

``` diff
 namespace System.IO {
     public sealed class BufferedStream : Stream {
+        public override void CopyTo(Stream destination, int bufferSize);
+        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        public override int Read(Span<byte> destination);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public static class Path {
+        public static bool EndsInDirectorySeparator(ReadOnlySpan<char> path);
+        public static bool EndsInDirectorySeparator(string path);
+        public static string Join(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, ReadOnlySpan<char> path3, ReadOnlySpan<char> path4);
+        public static string Join(string path1, string path2, string path3, string path4);
+        public static string Join(params string[] paths);
+        public static ReadOnlySpan<char> TrimEndingDirectorySeparator(ReadOnlySpan<char> path);
+        public static string TrimEndingDirectorySeparator(string path);
     }
     public class StreamReader : TextReader {
-        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize, bool leaveOpen);
+        public StreamReader(Stream stream, Encoding encoding = null, bool detectEncodingFromByteOrderMarks = true, int bufferSize = -1, bool leaveOpen = false);
     }
     public class StreamWriter : TextWriter {
-        public StreamWriter(Stream stream, Encoding encoding, int bufferSize, bool leaveOpen);
+        public StreamWriter(Stream stream, Encoding encoding = null, int bufferSize = -1, bool leaveOpen = false);
+        public override void Write(string format, object arg0);
+        public override void Write(string format, object arg0, object arg1);
+        public override void Write(string format, object arg0, object arg1, object arg2);
+        public override void Write(string format, params object[] arg);
+        public override void WriteLine(string format, object arg0);
+        public override void WriteLine(string format, object arg0, object arg1);
+        public override void WriteLine(string format, object arg0, object arg1, object arg2);
+        public override void WriteLine(string format, params object[] arg);
     }
     public class StringWriter : TextWriter {
+        public override void Write(StringBuilder value);
+        public override Task WriteAsync(StringBuilder value, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteLine(StringBuilder value);
+        public override Task WriteLineAsync(StringBuilder value, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

