# Microsoft.AspNetCore.Components.Rendering

``` diff
 namespace Microsoft.AspNetCore.Components.Rendering {
     public class HtmlRenderer : Renderer {
+        public HtmlRenderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory, Func<string, string> htmlEncoder);
-        public HtmlRenderer(IServiceProvider serviceProvider, Func<string, string> htmlEncoder, IDispatcher dispatcher);

+        public override Dispatcher Dispatcher { get; }
-        public Task<ComponentRenderedText> RenderComponentAsync(Type componentType, ParameterCollection initialParameters);

+        public Task<ComponentRenderedText> RenderComponentAsync(Type componentType, ParameterView initialParameters);
-        public Task<ComponentRenderedText> RenderComponentAsync<TComponent>(ParameterCollection initialParameters) where TComponent : IComponent;

+        public Task<ComponentRenderedText> RenderComponentAsync<TComponent>(ParameterView initialParameters) where TComponent : IComponent;
     }
-    public interface IDispatcher {
 {
-        Task Invoke(Action action);

-        Task<TResult> Invoke<TResult>(Func<TResult> function);

-        Task InvokeAsync(Func<Task> asyncAction);

-        Task<TResult> InvokeAsync<TResult>(Func<Task<TResult>> asyncFunction);

-    }
     public readonly struct RenderBatch {
-        public ArrayRange<int> DisposedEventHandlerIDs { get; }
+        public ArrayRange<ulong> DisposedEventHandlerIDs { get; }
     }
     public abstract class Renderer : IDisposable {
-        public Renderer(IServiceProvider serviceProvider);

-        public Renderer(IServiceProvider serviceProvider, IDispatcher dispatcher);

+        public Renderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory);
+        public abstract Dispatcher Dispatcher { get; }
-        public static IDispatcher CreateDefaultDispatcher();

-        public virtual Task DispatchEventAsync(int eventHandlerId, EventFieldInfo fieldInfo, UIEventArgs eventArgs);

+        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo fieldInfo, UIEventArgs eventArgs);
-        public virtual Task Invoke(Action workItem);

-        public virtual Task InvokeAsync(Func<Task> workItem);

-        protected Task RenderRootComponentAsync(int componentId, ParameterCollection initialParameters);

+        protected Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);
     }
 }
```

