# .NET 5.0.13 - December 14, 2021

The .NET 5.0.13, .NET 5.0.404 SDK  and [.NET SDK 5.0.210](5.0.210.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.404
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Deployment Update

Customers that have opted to receive .NET Core updates via the Microsoft Update channel will be offered updates to the Hosting Bundle starting with the December 2021 update. Updates for other .NET Core bundles (.NET Core Runtime, ASP.NET Core Runtime, Windows Desktop Runtime, and SDK) have been offered via Microsoft Update to customers that opt in since December 2020. See this [blog post](https://devblogs.microsoft.com/dotnet/net-core-updates-coming-to-microsoft-update) for more information.

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Windows SDK Updates

.NET SDK 5.0.404 and .NET SDK 5.0.210 include several fixes to the Windows SDK targeting packages produced by [C#/WinRT 1.4.1](https://github.com/microsoft/CsWinRT/releases/tag/1.4.1.211117.1).

## Notable Changes
.NET 5.0.13 release carries security and non-security fixes.

# Microsoft Security Advisory CVE-2021-43877 | ASP.NET Core Elevation of privilege Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET and .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An elevation of privilege vulnerability exists in ASP.NET Core Module (ANCM) that could allow elevation of privilege when .NET Core, .NET 5 and .NET 6 applications are hosted within IIS.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:.

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.13+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.13+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.13+is%3Aclosed+label%3Aservicing-approved+)



## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7036](https://github.com/dotnet/core/issues/7036) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.13.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.13-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.13-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/december-2021-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.13xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.win-x64.Microsoft.WindowsDesktop.App | 5.0.13-servicing.21567.2.symbols.nupkg
runtime.win-x86.Microsoft.WindowsDesktop.App | 5.0.13-servicing.21567.2.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.13.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.13.symbols.nupkg
Microsoft.WindowsDesktop.App | 5.0.13-servicing.21567.2.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.13.nupkg
runtime.win-arm64.Microsoft.WindowsDesktop.App | 5.0.13-servicing.21567.2.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.13.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.13.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.13.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.13.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.13.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.13.symbols.nupkg
Microsoft.ILVerification | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NET.Sdk.IL | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.13.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.13.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.13.symbols.nupkg
Microsoft.NET.HostModel | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.13.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.13.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Internal | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.13.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
Microsoft.NETCore.BrowserDebugHost.Transport | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.13.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.linux-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.13.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.13.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.13.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.13.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.13.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.TestHost | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.13.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.13.symbols.nupkg
dotnet-ilverify | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.13.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.13.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.13.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 5.0.13-servicing.21565.16.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.App | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.13.symbols.nupkg
Microsoft.NETCore.DotNetHost | 5.0.13.symbols.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.13.symbols.nupkg
Microsoft.NETCore.ILAsm | 5.0.13-servicing.21565.16.symbols.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.13.symbols.nupkg
dotnet-sql-cache | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authorization | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.13.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.13.symbols.nupkg
Microsoft.JSInterop | 5.0.13.symbols.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.13.symbols.nupkg
Microsoft.Extensions.Identity.Core | 5.0.13.symbols.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.13.symbols.nupkg
Microsoft.Extensions.Localization | 5.0.13.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.13.symbols.nupkg
Microsoft.Extensions.ObjectPool | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Metadata | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.13.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.13.symbols.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.13.nupkg
dotnet-sql-cache | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.13.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.13.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.13.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.13.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.13.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.13.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.13.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.13.nupkg
Microsoft.AspNetCore.Owin | 5.0.13.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.13.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.13.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.13.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.13.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.13.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.13.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.13.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.13.nupkg
Microsoft.Extensions.Identity.Core | 5.0.13.nupkg
Microsoft.Extensions.WebEncoders | 5.0.13.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.13.nupkg
Microsoft.AspNetCore.Metadata | 5.0.13.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.13.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.13.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.13.symbols.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.13.symbols.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.13.symbols.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.TestHost | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.13.symbols.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.13.symbols.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.13.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Owin | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.13.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.13.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.13.symbols.nupkg
Microsoft.dotnet-openapi | 5.0.13.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.13.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.13.nupkg
Microsoft.JSInterop | 5.0.13.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.13.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.13.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.13.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.13.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.13.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.13.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.13.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.13.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.13.nupkg
Microsoft.dotnet-openapi | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.13.symbols.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.13.symbols.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.13.symbols.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.13.symbols.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.13.symbols.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.13.symbols.nupkg
Microsoft.Extensions.WebEncoders | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.13.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.13.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.13.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.13.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.13.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.13.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.13.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.13.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.13.nupkg
Microsoft.AspNetCore.Components | 5.0.13.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.13.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.13.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.13.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.13.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.13.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.13.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.13.symbols.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.13.nupkg
Microsoft.AspNetCore.Authorization | 5.0.13.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.13.nupkg
Microsoft.AspNetCore.TestHost | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.13.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.13.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.13.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.13.nupkg
Microsoft.Extensions.ObjectPool | 5.0.13.nupkg
Microsoft.Extensions.Localization | 5.0.13.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.13.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.13.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.13.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.13.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.13.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.13.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.13.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.13.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.13.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.13.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.13.nupkg
Microsoft.EntityFrameworkCore | 5.0.13.symbols.nupkg
dotnet-ef | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.13.symbols.nupkg
Microsoft.Data.Sqlite.Core | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.13.nupkg
Microsoft.Data.Sqlite | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.13.symbols.nupkg
dotnet-ef | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.13.nupkg
Microsoft.Data.Sqlite.Core | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.13.symbols.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.13.nupkg
Microsoft.EntityFrameworkCore | 5.0.13.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.13.nupkg
FSharp.Compiler.Service | 40.0.0-preview.21514.6.nupkg
FSharp.Core | 5.0.2-beta.21514.6.nupkg
Microsoft.FSharp.Compiler | 11.4.2-beta.21514.6.nupkg






[//]: # ( Runtime 5.0.13)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/80f00d66-a3ca-40de-b566-38bebe0d4dce/028e295c9ac23f20d2058f349971b8bb/dotnet-runtime-5.0.13-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b8880373-1127-4830-a700-d693745711b8/e07e0b2f67b5e6df1f5f54052d6b0ff2/dotnet-runtime-5.0.13-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1271e8ee-5e60-4b22-8584-eaec71386b5c/063374e028b632b03b2a8bd698bc418e/dotnet-runtime-5.0.13-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44a3ba41-53c7-4613-92e0-810cf9dd5134/a34cd5cdf20c8bc61f2a6762b1049de8/dotnet-runtime-5.0.13-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c740fe39-9a92-4de4-b78b-a85b991138fd/5b725b79ee22853ef6c74ec5f230f9f6/dotnet-runtime-5.0.13-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60ab6867-f33d-4708-8eb0-83018e4c22bd/04fb765d876f26c50cdc818323e6aaa6/dotnet-runtime-5.0.13-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5d89558c-bd0f-49fb-8406-9e4f2d5429f9/07d4ace475df29dffaa9ef5f49c37848/dotnet-runtime-5.0.13-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ca0a021-a94f-44ec-9d2d-06ae19b1c9c8/bd9b8dc81d80a40ef394e6e24c2a5a1a/dotnet-runtime-5.0.13-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bd6a6034-aa12-4a8b-a0a0-7f537e4edda7/07f3cb43013dd614937182c483e20587/dotnet-runtime-5.0.13-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/570f973d-ddab-480b-a8c6-9c52b60477e2/99773a43449935ccd8445ef48a7dc6d4/dotnet-runtime-5.0.13-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fccf43d2-3e62-4ede-b5a5-592a7ccded7b/6339f1fdfe3317df5b09adf65f0261ab/dotnet-runtime-5.0.13-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/52ad366b-a426-48aa-a142-10cca6a50ec3/b0cf38c1c3e57d4b617d23d78bcb7b92/dotnet-runtime-5.0.13-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4a79fcd5-d61b-4606-8496-68071c8099c6/2bf770ca40521e8c4563072592eadd06/dotnet-runtime-5.0.13-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/36819273-76cc-4670-92c8-36e681572834/378dfc4acfbe9464ccd29e4467ca697b/dotnet-runtime-5.0.13-win-x86.zip

[//]: # ( WindowsDesktop 5.0.13)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bfdc7ba8-a5e5-4301-8ad8-e4f9c231ee9a/acf0f00c3401f78a40615c412e469d96/windowsdesktop-runtime-5.0.13-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2bfb80f2-b8f2-44b0-90c1-d3c8c1c8eac8/409dd3d3367feeeda048f4ff34b32e82/windowsdesktop-runtime-5.0.13-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c8125c6b-d399-4be3-b201-8f1394fc3b25/724758f754fc7b67daba74db8d6d91d9/windowsdesktop-runtime-5.0.13-win-x86.exe

[//]: # ( ASP 5.0.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/534338be-7169-48b8-a673-3d8c950186ca/07797acb5b0a471dc77629f45112f600/aspnetcore-runtime-5.0.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09065281-5221-48d0-abc9-03416c75f33b/7ab96d1ea3accca3cd1b530db3d8ff27/aspnetcore-runtime-5.0.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab57eea1-f287-46aa-a996-5194f88486b9/4817b43df17adb8b6640244b7eb38af9/aspnetcore-runtime-5.0.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9b8e9741-44b3-42f5-90cf-10ec14e87dbf/c3772b7e949fd0b29f6b901d6d4f2622/aspnetcore-runtime-5.0.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9bedd81-fc00-491d-95c0-ce091997318d/5dc7b5738205165df97e69d9238f60d7/aspnetcore-runtime-5.0.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b71393db-7953-4eaf-aff7-6f799bf40718/68a8f4b74a5528aeb96514268651e3eb/aspnetcore-runtime-5.0.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/643e5f20-da2f-4f4e-9968-c3d2d0e87ced/838657346a3df371a970f08bc1b4a2cc/aspnetcore-runtime-5.0.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8bf11d66-d9b8-490f-a702-e30be74ab4ef/0f7f425c51027244263c4d38ef1bf474/aspnetcore-runtime-5.0.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aac560f3-eac8-437e-aebd-9830119deb10/6a3880161cf527e4ec71f67efe4d91ad/aspnetcore-runtime-5.0.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/47a8ac1b-be42-4ca9-a73c-b4a7560da28c/1e118313f7c85b23767e1a814edc93b6/aspnetcore-runtime-5.0.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/340f9482-fc43-4ef7-b434-e2ed57f55cb3/c641b805cef3823769409a6dbac5746b/aspnetcore-runtime-5.0.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/904bc6e0-0941-478d-8356-6ed733c2ad26/b9757f83ab974811537844afb17ff689/aspnetcore-runtime-5.0.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/08a0bb65-6004-4099-8289-945f1681d946/f77d62d5e200693bec1416d4aefa97f7/dotnet-hosting-5.0.13-win.exe

[//]: # ( SDK 5.0.404)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbc6105c-07b4-4cda-b438-91afa4e4f2f3/61411defdb5fff3736a9263718bca37b/dotnet-sdk-5.0.404-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21bf6b86-84a9-4cc4-9713-c812c18b1504/8ef52712e25b5075b91dd51b85ae170d/dotnet-sdk-5.0.404-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36338b49-8267-4305-b0a5-ab9720441cf5/277aa4781fbc39b3af97c3eb9cf79901/dotnet-sdk-5.0.404-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a22dee51-a8d2-44c8-ae77-294b5c091ffa/81aee20fc880efd10dd54c8d0ebda1e7/dotnet-sdk-5.0.404-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/efedb4fc-acec-4d03-a502-3e1ecc51eb0a/f4ee529ee13dc95bcd9146ca07e9174e/dotnet-sdk-5.0.404-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c1eb8c8-ac05-4dc7-9bef-307b3e450e9d/75e85b3d1662f60afd69572fd5df6884/dotnet-sdk-5.0.404-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/34168b27-d339-43f1-9aa2-8fb7a6ab92cf/064d2c2db90fb95ec6147768bd5d5127/dotnet-sdk-5.0.404-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8e682576-6d5e-4702-aed4-b7f77bb0dbc3/c7269d8dc54d73fbba942f38da843f60/dotnet-sdk-5.0.404-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90588609-df30-4cb7-b4aa-a2e71ec42c9a/9bc894713f459ebe73493552fd231807/dotnet-sdk-5.0.404-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/10430680-c4f3-4b0f-b779-e3cb4457b584/48074c4a2c349238b134667c9bc19923/dotnet-sdk-5.0.404-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/fbb54ff0-2dda-49f7-827d-0645c24897de/f17ada70648e847d838dbc96c15129d6/dotnet-sdk-5.0.404-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/44069ee2-ce02-41d7-bcc5-2168a1653278/cfc5131c81ae00a5f77f05f9963ec98d/dotnet-sdk-5.0.404-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/fd6872c1-331b-47f7-b44c-061093651652/5e04c7e7b8860f42660b317f3f52eeec/dotnet-sdk-5.0.404-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/425db9c7-af81-49a3-b4d8-da01945f683a/b78e739a6a7d302da7e1147b223d8005/dotnet-sdk-5.0.404-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b34b6944-78df-4004-852c-94433e48a5d5/df50f29231c47e0e2898bf85f0ff31f3/dotnet-sdk-5.0.404-win-x86.zip
